define(['@microsoft/load-themed-styles', 'vue'], function (loadThemedStyles, Vue) {

    Vue = Vue && Vue.hasOwnProperty('default') ? Vue['default'] : Vue;

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0

    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.

    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */

    var LEFT = 'left';
    var RIGHT = 'right';
    var NAME_REPLACEMENTS = (_a = {},
        _a[LEFT] = RIGHT,
        _a[RIGHT] = LEFT,
        _a);
    var _rtl = getRTL();
    /**
     * Gets the current RTL value.
     */
    function getRTL() {
        if (_rtl === undefined) {
            _rtl = typeof document !== 'undefined' && !!document.documentElement && document.documentElement.getAttribute('dir') === 'rtl';
        }
        return _rtl;
    }
    var _a;

    /**
     * Combine a set of styles together (but does not register css classes).
     * @param styleSets - One or more stylesets to be merged (each param can also be falsy).
     */

    // A packages cache that makes sure that we don't inject the same packageName twice in the same bundle -
    // this cache is local to the module closure inside this bundle
    var packagesCache = {};
    function setVersion(packageName, packageVersion) {
        if (typeof window !== 'undefined') {
            // tslint:disable-next-line:no-any
            var packages = (window.__packages__ = window.__packages__ || {});
            // We allow either the global packages or local packages caches to invalidate so testing can just clear the global to set this state
            if (!packages[packageName] || !packagesCache[packageName]) {
                packagesCache[packageName] = packageVersion;
                var versions = (packages[packageName] = packages[packageName] || []);
                versions.push(packageVersion);
            }
        }
    }

    setVersion('@uifabric/set-version', '6.0.0');

    // @uifabric/merge-styles@6.15.0
    setVersion('@uifabric/merge-styles', '6.15.0');

    function type () {
      var arguments$1 = arguments;

      for (var _len = arguments.length, types = new Array(_len), _key = 0; _key < _len; _key++) {
        types[_key] = arguments$1[_key];
      }

      types.push('');
      return {
        props: {
          type: {
            type: String,
            default: '',
            validator: function validator(value) {
              return types.indexOf(value) !== -1;
            }
          }
        }
      };
    }

    var disabled = {
      props: {
        disabled: {
          type: Boolean,
          default: false
        }
      }
    };

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, {
          value: value,
          enumerable: true,
          configurable: true,
          writable: true
        });
      } else {
        obj[key] = value;
      }

      return obj;
    }

    var icon = {
      props: {
        icon: String
      },
      computed: {
        iconClass: function iconClass() {
          return _defineProperty({}, "ms-Icon--".concat(this.icon), !!this.icon);
        }
      }
    };

    var button = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('button',{staticClass:"ms-Button",class:_vm.buttonClass,on:{"click":_vm.clickEvent}},[(_vm.icon && _vm.type == 'hero')?_c('span',{staticClass:"ms-Button-icon"},[_c('i',{staticClass:"ms-Icon",class:_vm.iconClass})]):_vm._e(),_vm._v(" "),_c('span',{staticClass:"ms-Button-label"},[_vm._t("default")],2),_vm._v(" "),(_vm.description && _vm.type == 'compound')?_c('span',{staticClass:"ms-Button-description"},[_vm._v(" "+_vm._s(_vm.description)+" ")]):_vm._e()])},staticRenderFns: [],
      name: 'ou-button',

      mixins: [
        type('primary', 'hero', 'compound', 'small', 'default'),
        disabled,
        icon
      ],

      props: {
        description: String
      },

      computed: {
        buttonClass: function buttonClass() {
          var obj;

          return ( obj = {}, obj[("ms-Button--" + (this.type))] = !!this.type, obj['is-disabled'] =  this.disabled, obj );
        }
      },

      methods: {
        clickEvent: function clickEvent() {
          if (!this.disabled) { this.$emit('click'); }
        }
      }
    };

    var callout = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',[_c('div',{ref:"callout",staticClass:"ms-Callout is-hidden",class:_vm.calloutClass},[_c('div',{staticClass:"ms-Callout-main"},[(_vm.showClose)?_c('button',{staticClass:"ms-Callout-close"},[_c('i',{staticClass:"ms-Icon ms-Icon--Clear"})]):_vm._e(),_vm._v(" "),_c('div',{staticClass:"ms-Callout-header"},[_c('p',{staticClass:"ms-Callout-title"},[_vm._v(_vm._s(_vm.title))])]),_vm._v(" "),_c('div',{staticClass:"ms-Callout-inner"},[_c('div',{staticClass:"ms-Callout-content"},[(_vm.content)?_c('p',{staticClass:"ms-Callout-subText"},[_vm._v(_vm._s(_vm.content))]):_vm._t("content")],2),_vm._v(" "),_c('div',{staticClass:"ms-Callout-actions"},[_vm._t("actions")],2)])])]),_vm._v(" "),_c('span',{ref:"calloutTrigger"},[_vm._t("default")],2)])},staticRenderFns: [],
      name: 'ou-callout',

      mixins: [type('actionText', 'OOBE', 'peek')],

      props: {
        position: {
          type: String,
          default: 'right',
          validator: function validator(value) {
            return ['right', 'left', 'top', 'bottom'].includes(value);
          }
        },

        showClose: {
          type: Boolean,
          default: false
        },

        title: String,
        content: String
      },
      data: function data() {
        return {
          calloutInstance: null
        };
      },
      computed: {
        calloutClass: function calloutClass() {
          var obj;

          return ( obj = {}, obj[("ms-Callout--" + (this.type))] = !!this.type, obj['ms-Callout--close'] =  this.showClose, obj );
        }
      },

      mounted: function mounted() {
        this.calloutInstance = new this.$fabric.Callout(
          this.$refs.callout,
          this.$refs.calloutTrigger,
          this.position
        );
      }
    };

    var CONTEXT_STATE_CLASS = "is-open";
    var MODAL_STATE_POSITIONED = "is-positioned";
    var CONTEXT_HOST_MAIN_CLASS = "ms-ContextualHost-main";
    var CONTEXT_HOST_BEAK_CLASS = "ms-ContextualHost-beak";
    var ARROW_LEFT_CLASS = "ms-ContextualHost--arrowLeft";
    var ARROW_TOP_CLASS = "ms-ContextualHost--arrowTop";
    var ARROW_BOTTOM_CLASS = "ms-ContextualHost--arrowBottom";
    var ARROW_RIGHT_CLASS = "ms-ContextualHost--arrowRight";
    var MODIFIER_BASE = "ms-ContextualHost--";
    var ARROW_SIZE = 28;
    var ARROW_OFFSET = 8;

    var ContextualHost = function () {
      function ContextualHost(content, direction, targetElement, hasArrow, modifiers, matchTargetWidth, disposalCallback) {
        var this$1 = this;

        if (hasArrow === void 0) {
          hasArrow = true;
        }

        this._resizeAction = this._resizeAction.bind(this);
        this._dismissAction = this._dismissAction.bind(this);
        this._handleKeyUpDismiss = this._handleKeyUpDismiss.bind(this);
        this._matchTargetWidth = matchTargetWidth || false;
        this._direction = direction;
        this._container = this.createContainer();
        this._contextualHost = this._container;
        this._contextualHostMain = this._contextualHost.getElementsByClassName(CONTEXT_HOST_MAIN_CLASS)[0];

        this._contextualHostMain.appendChild(content);

        this._hasArrow = hasArrow;
        this._arrow = this._container.getElementsByClassName(CONTEXT_HOST_BEAK_CLASS)[0];
        this._targetElement = targetElement;

        this._openModal();

        this._setResizeDisposal();

        if (disposalCallback) {
          this._disposalCallback = disposalCallback;
        }

        if (modifiers) {
          for (var i = 0; i < modifiers.length; i++) {
            this$1._container.classList.add(MODIFIER_BASE + modifiers[i]);
          }
        }

        if (!ContextualHost.hosts) {
          ContextualHost.hosts = [];
        }

        ContextualHost.hosts.push(this);
      }

      ContextualHost.prototype.disposeModal = function () {
        if (ContextualHost.hosts.length > 0) {
          window.removeEventListener("resize", this._resizeAction, false);
          document.removeEventListener("click", this._dismissAction, true);
          document.removeEventListener("keyup", this._handleKeyUpDismiss, true);

          this._container.parentNode.removeChild(this._container);

          if (this._disposalCallback) {
            this._disposalCallback();
          }

          var index = ContextualHost.hosts.indexOf(this);
          ContextualHost.hosts.splice(index, 1);
          var i = ContextualHost.hosts.length;

          while (i--) {
            ContextualHost.hosts[i].disposeModal();
            ContextualHost.hosts.splice(i, 1);
          }
        }
      };

      ContextualHost.prototype.setChildren = function (value) {
        if (!this._children) {
          this._children = [];
        }

        this._children.push(value);
      };

      ContextualHost.prototype.contains = function (value) {
        return this._container.contains(value);
      };

      ContextualHost.prototype.createContainer = function () {
        var ContextualHost0 = document.createElement("div");
        ContextualHost0.setAttribute("class", "ms-ContextualHost");
        ContextualHost0.innerHTML += " ";
        var ContextualHost0c1 = document.createElement("div");
        ContextualHost0c1.setAttribute("class", CONTEXT_HOST_MAIN_CLASS);
        ContextualHost0c1.innerHTML += " ";
        ContextualHost0.appendChild(ContextualHost0c1);
        ContextualHost0.innerHTML += " ";
        var ContextualHost0c3 = document.createElement("div");
        ContextualHost0c3.setAttribute("class", CONTEXT_HOST_BEAK_CLASS);
        ContextualHost0.appendChild(ContextualHost0c3);
        ContextualHost0.innerHTML += "";
        return ContextualHost0;
      };

      ContextualHost.prototype._openModal = function () {
        var _this = this;

        this._copyModalToBody();

        this._saveModalSize();

        this._findAvailablePosition();

        this._showModal();

        setTimeout(function () {
          _this._setDismissClick();
        }, 100);
      };

      ContextualHost.prototype._findAvailablePosition = function () {
        var _posOk;

        switch (this._direction) {
          case "left":
            _posOk = this._positionOk(this._tryPosModalLeft.bind(this), this._tryPosModalRight.bind(this), this._tryPosModalBottom.bind(this), this._tryPosModalTop.bind(this));

            this._setPosition(_posOk);

            break;

          case "right":
            _posOk = this._positionOk(this._tryPosModalRight.bind(this), this._tryPosModalLeft.bind(this), this._tryPosModalBottom.bind(this), this._tryPosModalTop.bind(this));

            this._setPosition(_posOk);

            break;

          case "top":
            _posOk = this._positionOk(this._tryPosModalTop.bind(this), this._tryPosModalBottom.bind(this));

            this._setPosition(_posOk);

            break;

          case "bottom":
            _posOk = this._positionOk(this._tryPosModalBottom.bind(this), this._tryPosModalTop.bind(this));

            this._setPosition(_posOk);

            break;

          default:
            this._setPosition();

        }
      };

      ContextualHost.prototype._showModal = function () {
        this._container.classList.add(CONTEXT_STATE_CLASS);
      };

      ContextualHost.prototype._positionOk = function (pos1, pos2, pos3, pos4) {
        var _posOk;

        _posOk = pos1();

        if (!_posOk) {
          _posOk = pos2();

          if (!_posOk && pos3) {
            _posOk = pos3();

            if (!_posOk && pos4) {
              _posOk = pos4();
            }
          }
        }

        return _posOk;
      };

      ContextualHost.prototype._calcLeft = function (mWidth, teWidth, teLeft) {
        var mHalfWidth = mWidth / 2;
        var teHalf = teWidth / 2;
        var mHLeft = teLeft + teHalf - mHalfWidth;
        mHLeft = mHLeft < mHalfWidth ? teLeft : mHLeft;
        return mHLeft;
      };

      ContextualHost.prototype._calcTop = function (mHeight, teHeight, teTop) {
        var mHalfWidth = mHeight / 2;
        var teHalf = teHeight / 2;
        var mHLeft = teTop + teHalf - mHalfWidth;
        mHLeft = mHLeft < mHalfWidth ? teTop : mHLeft;
        return mHLeft;
      };

      ContextualHost.prototype._setPosition = function (curDirection) {
        var teBR = this._targetElement.getBoundingClientRect();

        var teLeft = teBR.left;
        var teRight = teBR.right;
        var teTop = teBR.top;
        var teWidth = teBR.width;
        var teHeight = teBR.height;
        var mHLeft;
        var mHTop;
        var mWidth = "";
        var arrowTop;
        var arrowLeft;
        var windowX = window.scrollX ? window.scrollX : 0;
        var windowY = window.scrollY ? window.scrollY : 0;
        var arrowSpace = this._hasArrow ? ARROW_SIZE : 0;

        if (this._matchTargetWidth) {
          mWidth = "width: " + this._modalWidth + "px;";
        }

        switch (curDirection) {
          case "left":
            mHLeft = teLeft - this._modalWidth - arrowSpace;
            mHTop = this._calcTop(this._modalHeight, teHeight, teTop);
            mHTop += window.scrollY ? window.scrollY : 0;

            this._container.setAttribute("style", "top: " + mHTop + "px; left: " + mHLeft + "px;" + mWidth);

            this._container.classList.add(MODAL_STATE_POSITIONED);

            if (this._hasArrow) {
              this._container.classList.add(ARROW_RIGHT_CLASS);

              arrowTop = teTop + windowY - mHTop + ARROW_OFFSET;

              this._arrow.setAttribute("style", "top: " + arrowTop + "px;");
            }

            break;

          case "right":
            mHTop = this._calcTop(this._modalHeight, teHeight, teTop);
            mHTop += windowY;
            mHLeft = teRight + arrowSpace;

            this._container.setAttribute("style", "top: " + mHTop + "px; left: " + mHLeft + "px;" + mWidth);

            this._container.classList.add(MODAL_STATE_POSITIONED);

            if (this._hasArrow) {
              arrowTop = windowY + teTop - mHTop + ARROW_OFFSET;

              this._arrow.setAttribute("style", "top: " + arrowTop + "px;");

              this._container.classList.add(ARROW_LEFT_CLASS);
            }

            break;

          case "top":
            mHLeft = this._calcLeft(this._modalWidth, this._teWidth, teLeft);
            mHTop = teTop - this._modalHeight - arrowSpace;
            mHTop += windowY;

            this._container.setAttribute("style", "top: " + mHTop + "px; left: " + mHLeft + "px;" + mWidth);

            this._container.classList.add(MODAL_STATE_POSITIONED);

            if (this._hasArrow) {
              arrowTop = this._modalHeight - arrowSpace / 2;
              arrowLeft = Math.max(windowX + teLeft - mHLeft + (teWidth - arrowSpace) / 2, ARROW_OFFSET);

              this._arrow.setAttribute("style", "top: " + arrowTop + "px; left: " + arrowLeft + "px;");

              this._container.classList.add(ARROW_BOTTOM_CLASS);
            }

            break;

          case "bottom":
            mHLeft = mHLeft = this._calcLeft(this._modalWidth, this._teWidth, teLeft);
            mHTop = teTop + teHeight + arrowSpace;
            mHTop += window.scrollY ? window.scrollY : 0;

            this._container.setAttribute("style", "top: " + mHTop + "px; left: " + mHLeft + "px;" + mWidth);

            this._container.classList.add(MODAL_STATE_POSITIONED);

            if (this._hasArrow) {
              arrowLeft = Math.max(windowX + teLeft - mHLeft + (teWidth - arrowSpace) / 2, ARROW_OFFSET);

              this._arrow.setAttribute("style", "left: " + arrowLeft + "px;");

              this._container.classList.add(ARROW_TOP_CLASS);
            }

            break;

          default:
            this._container.setAttribute("style", "top: 50%; left: 50%; transform: translateX(-50%) translateY(-50%);");

        }
      };

      ContextualHost.prototype._tryPosModalLeft = function () {
        var teLeft = this._targetElement.getBoundingClientRect().left;

        if (teLeft < this._modalWidth) {
          return false;
        } else {
          return "left";
        }
      };

      ContextualHost.prototype._tryPosModalRight = function () {
        var teRight = this._targetElement.getBoundingClientRect().right;

        var w = Math.max(document.documentElement.clientWidth, window.innerWidth || 0);

        if (w - teRight < this._modalWidth) {
          return false;
        } else {
          return "right";
        }
      };

      ContextualHost.prototype._tryPosModalBottom = function () {
        var teBottom = window.innerHeight - this._targetElement.getBoundingClientRect().bottom;

        if (teBottom < this._modalHeight) {
          return false;
        } else {
          return "bottom";
        }
      };

      ContextualHost.prototype._tryPosModalTop = function () {
        var teTop = this._targetElement.getBoundingClientRect().top;

        if (teTop < this._modalHeight) {
          return false;
        } else {
          return "top";
        }
      };

      ContextualHost.prototype._copyModalToBody = function () {
        document.body.appendChild(this._container);
      };

      ContextualHost.prototype._saveModalSize = function () {
        var _modalStyles = window.getComputedStyle(this._container);

        this._container.setAttribute("style", "opacity: 0; z-index: -1");

        this._container.classList.add(MODAL_STATE_POSITIONED);

        this._container.classList.add(CONTEXT_STATE_CLASS);

        if (this._matchTargetWidth) {
          var teStyles = window.getComputedStyle(this._targetElement);
          this._modalWidth = this._targetElement.getBoundingClientRect().width + (parseInt(teStyles.marginLeft, 10) + parseInt(teStyles.marginLeft, 10));
        } else {
          this._modalWidth = this._container.getBoundingClientRect().width + (parseInt(_modalStyles.marginLeft, 10) + parseInt(_modalStyles.marginRight, 10));

          this._container.setAttribute("style", "");
        }

        this._modalHeight = this._container.getBoundingClientRect().height + (parseInt(_modalStyles.marginTop, 10) + parseInt(_modalStyles.marginBottom, 10));

        this._container.classList.remove(MODAL_STATE_POSITIONED);

        this._container.classList.remove(CONTEXT_STATE_CLASS);

        this._teWidth = this._targetElement.getBoundingClientRect().width;
        this._teHeight = this._targetElement.getBoundingClientRect().height;
      };

      ContextualHost.prototype._dismissAction = function (e) {
        if (!this._container.contains(e.target) && e.target !== this._container) {
          if (this._children !== undefined) {
            var isChild_1 = false;

            this._children.map(function (child) {
              if (child !== undefined) {
                isChild_1 = child.contains(e.target);
              }
            });

            if (!isChild_1) {
              this.disposeModal();
            }
          } else {
            this.disposeModal();
          }
        }
      };

      ContextualHost.prototype._setDismissClick = function () {
        document.addEventListener("click", this._dismissAction, true);
        document.addEventListener("keyup", this._handleKeyUpDismiss, true);
      };

      ContextualHost.prototype._handleKeyUpDismiss = function (e) {
        if (e.keyCode === 32 || e.keyCode === 27) {
          this._dismissAction(e);
        }
      };

      ContextualHost.prototype._resizeAction = function () {
        this.disposeModal();
      };

      ContextualHost.prototype._setResizeDisposal = function () {
        window.addEventListener("resize", this._resizeAction, false);
      };

      return ContextualHost;
    }();

    var STATE_HIDDEN = "is-hidden";
    var CLOSE_BUTTON_CLASS = ".ms-Callout-close";
    var MODIFIER_OOBE_CLASS = "ms-Callout--OOBE";

    var Callout = function () {
      function Callout(container, addTarget, position) {
        this._container = container;
        this._addTarget = addTarget;
        this._position = position;
        this._closeButton = container.querySelector(CLOSE_BUTTON_CLASS);

        this._setOpener();
      }

      Callout.prototype._setOpener = function () {
        this._addTarget.addEventListener("click", this._clickHandler.bind(this), true);

        this._addTarget.addEventListener("keyup", this._keyupHandler.bind(this), true);
      };

      Callout.prototype._openContextMenu = function () {
        var modifiers = [];

        if (this._hasModifier(MODIFIER_OOBE_CLASS)) {
          modifiers.push("primaryArrow");
        }

        this._container.classList.remove(STATE_HIDDEN);

        this._contextualHost = new ContextualHost(this._container, this._position, this._addTarget, true, modifiers);

        if (this._closeButton) {
          this._closeButton.addEventListener("click", this._closeHandler.bind(this), false);
        }
      };

      Callout.prototype._hasModifier = function (modifierClass) {
        return this._container.classList.contains(modifierClass);
      };

      Callout.prototype._closeHandler = function (e) {
        if (this._contextualHost != null) {
          this._contextualHost.disposeModal();
        }

        this._closeButton.removeEventListener("click", this._closeHandler.bind(this), false);

        this._addTarget.removeEventListener("click", this._clickHandler.bind(this), true);

        this._addTarget.removeEventListener("keyup", this._keyupHandler.bind(this), true);
      };

      Callout.prototype._clickHandler = function (e) {
        this._openContextMenu();
      };

      Callout.prototype._keyupHandler = function (event) {
        if (event.keyCode === 32) {
          event.stopPropagation();
          event.preventDefault();

          this._openContextMenu();
        } else {
          this._closeHandler(event);
        }
      };

      return Callout;
    }();

    var CheckBox = function () {
      function CheckBox(container) {
        this._container = container;
        this._choiceField = this._container.querySelector(".ms-CheckBox-field");
        this._choiceInput = this._container.querySelector(".ms-CheckBox-input");

        if (this._choiceInput.checked) {
          this._choiceField.setAttribute("aria-checked", "true");
        }

        if (this._choiceField.getAttribute("aria-checked") === "true") {
          this._choiceField.classList.add("is-checked");
        }

        this._addListeners();
      }

      CheckBox.prototype.getValue = function () {
        return this._choiceField.getAttribute("aria-checked") === "true" ? true : false;
      };

      CheckBox.prototype.toggle = function () {
        if (this.getValue()) {
          this.unCheck();
        } else {
          this.check();
        }

        this._choiceInput.click();
      };

      CheckBox.prototype.check = function () {
        this._choiceField.setAttribute("aria-checked", "true");

        this._choiceField.classList.add("is-checked");
      };

      CheckBox.prototype.unCheck = function () {
        this._choiceField.setAttribute("aria-checked", "false");

        this._choiceField.classList.remove("is-checked");
      };

      CheckBox.prototype.removeListeners = function () {
        this._choiceField.removeEventListener("focus", this._FocusHandler.bind(this));

        this._choiceField.removeEventListener("blur", this._BlurHandler.bind(this));

        this._choiceField.removeEventListener("click", this._ClickHandler.bind(this));

        this._choiceField.removeEventListener("keydown", this._KeydownHandler.bind(this));
      };

      CheckBox.prototype._addListeners = function (events) {
        var ignore = events && events.ignore;

        if (!ignore || !(ignore.indexOf("focus") > -1)) {
          this._choiceField.addEventListener("focus", this._FocusHandler.bind(this), false);
        }

        if (!ignore || !(ignore.indexOf("blur") > -1)) {
          this._choiceField.addEventListener("blur", this._BlurHandler.bind(this), false);
        }

        if (!ignore || !(ignore.indexOf("click") > -1)) {
          this._choiceField.addEventListener("click", this._ClickHandler.bind(this), false);
        }

        if (!ignore || !(ignore.indexOf("keydown") > -1)) {
          this._choiceField.addEventListener("keydown", this._KeydownHandler.bind(this), false);
        }
      };

      CheckBox.prototype._FocusHandler = function () {
        this._choiceField.classList.add("in-focus");
      };

      CheckBox.prototype._BlurHandler = function () {
        this._choiceField.classList.remove("in-focus");
      };

      CheckBox.prototype._ClickHandler = function (event) {
        event.stopPropagation();
        event.preventDefault();

        if (!this._choiceField.classList.contains("is-disabled")) {
          this.toggle();
        }
      };

      CheckBox.prototype._KeydownHandler = function (event) {
        if (event.keyCode === 32) {
          event.stopPropagation();
          event.preventDefault();

          if (!this._choiceField.classList.contains("is-disabled")) {
            this.toggle();
          }
        }
      };

      return CheckBox;
    }();

    var eventHub = {
      data: function data() {
        return {
          eventHub: new Vue()
        };
      },
      provide: function provide() {
        return {
          eventHub: this.eventHub
        };
      }
    };

    var RadioButton = function () {
      function RadioButton(container) {
        this._container = container;
        this._choiceField = this._container.querySelector(".ms-RadioButton-field");
        this._choiceInput = this._container.querySelector(".ms-RadioButton-input");

        if (this._choiceField.getAttribute("aria-checked") === "true") {
          this._choiceField.classList.add("is-checked");
        }

        this._addListeners();
      }

      RadioButton.prototype.getValue = function () {
        return this._choiceField.getAttribute("aria-checked") === "true" ? true : false;
      };

      RadioButton.prototype.toggle = function () {
        if (this.getValue()) {
          this.unCheck();
        } else {
          this.check();
        }
      };

      RadioButton.prototype.check = function () {
        this._choiceField.setAttribute("aria-checked", "true");

        this._choiceField.classList.add("is-checked");

        this._choiceInput.checked = true;
      };

      RadioButton.prototype.unCheck = function () {
        this._choiceField.setAttribute("aria-checked", "false");

        this._choiceField.classList.remove("is-checked");

        this._choiceInput.checked = false;
      };

      RadioButton.prototype.removeListeners = function () {
        this._choiceField.removeEventListener("focus", this._FocusHandler.bind(this));

        this._choiceField.removeEventListener("blur", this._BlurHandler.bind(this));

        this._choiceField.removeEventListener("click", this._RadioClickHandler.bind(this));

        this._choiceField.addEventListener("keydown", this._RadioKeydownHandler.bind(this));
      };

      RadioButton.prototype._addListeners = function () {
        this._choiceField.addEventListener("focus", this._FocusHandler.bind(this), false);

        this._choiceField.addEventListener("blur", this._BlurHandler.bind(this), false);

        this._choiceField.addEventListener("click", this._RadioClickHandler.bind(this), false);

        this._choiceField.addEventListener("keydown", this._RadioKeydownHandler.bind(this), false);
      };

      RadioButton.prototype._RadioClickHandler = function (event) {
        event.stopPropagation();
        event.preventDefault();

        if (!this._choiceField.classList.contains("is-disabled")) {
          this._dispatchSelectEvent();
        }
      };

      RadioButton.prototype._dispatchSelectEvent = function () {
        var objDict = {
          bubbles: true,
          cancelable: true,
          detail: {
            name: this._choiceField.getAttribute("name"),
            item: this
          }
        };

        this._choiceField.dispatchEvent(new CustomEvent("msChoicefield", objDict));
      };

      RadioButton.prototype._RadioKeydownHandler = function (event) {
        if (event.keyCode === 32) {
          event.stopPropagation();
          event.preventDefault();

          if (!this._choiceField.classList.contains("is-disabled")) {
            this._dispatchSelectEvent();
          }
        }
      };

      RadioButton.prototype._FocusHandler = function () {
        this._choiceField.classList.add("in-focus");
      };

      RadioButton.prototype._BlurHandler = function () {
        this._choiceField.classList.remove("in-focus");
      };

      return RadioButton;
    }();

    var ChoiceFieldGroup$1 = function () {
      function ChoiceFieldGroup(container) {
        this._choiceFieldGroup = container;
        this._choiceFieldComponents = [];

        this._initalSetup();

        this._addListeners();
      }

      ChoiceFieldGroup.prototype.removeListeners = function () {
        this._choiceFieldGroup.removeEventListener("msChoicefield", this._ChoiceFieldHandler.bind(this));
      };

      ChoiceFieldGroup.prototype._initalSetup = function () {
        var this$1 = this;

        var choiceFieldElements = this._choiceFieldGroup.querySelectorAll(".ms-RadioButton");

        for (var i = 0; i < choiceFieldElements.length; i++) {
          this$1._choiceFieldComponents[i] = new RadioButton(choiceFieldElements[i]);
        }
      };

      ChoiceFieldGroup.prototype._addListeners = function () {
        document.addEventListener("msChoicefield", this._ChoiceFieldHandler.bind(this), false);
      };

      ChoiceFieldGroup.prototype._ChoiceFieldHandler = function (event) {
        var this$1 = this;

        var name = event.detail.name;
        var selectedChoice = event.detail.item;

        if (this._choiceFieldGroup.id === name) {
          for (var i = 0; i < this._choiceFieldComponents.length; i++) {
            this$1._choiceFieldComponents[i].unCheck();
          }

          selectedChoice.check();
        }
      };

      return ChoiceFieldGroup;
    }();

    var ContextualMenu = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"inline-block"},[_c('span',{ref:"contextualMenuTrigger",staticClass:"inline-block"},[_vm._t("default")],2),_vm._v(" "),_c('ul',{ref:"contextualMenu",staticClass:"ms-ContextualMenu is-hidden",class:_vm.contextualMenuClass},[_vm._t("list")],2)])},staticRenderFns: [],_scopeId: 'data-v-4d60802a',
        name: 'ou-contextual-menu',

        mixins: [type('multiselect'), eventHub],

        props: {
          value: {
            type: Array,
            default: function default$1() {
              return [];
            }
          }
        },

        computed: {
          contextualMenuClass: function contextualMenuClass() {
            var obj;

            return ( obj = {}, obj[("ms-ContextualMenu--" + (this.type))] = !!this.type, obj );
          }
        },

        watch: {
          value: function value() {
            this.setChildrenValue();
          }
        },

        created: function created() {
          this.eventHub.$on('updateValue', this.updateValue);
        },
    	data: function data(){
    		return {
    			contextualMenuInstance : null
    		}
    	},
        mounted: function mounted() {
          this.setChildrenValue();

          this.contextualMenuInstance = new this.$fabric.ContextualMenu(
            this.$refs.contextualMenu,
            this.$refs.contextualMenuTrigger
          );
        },

        beforeDestroy: function beforeDestroy() {
          this.eventHub.$off('updateValue', this.updateValue);
        },

        methods: {
          setChildrenValue: function setChildrenValue() {
            if (this.type == 'multiselect') {
              this.eventHub.$emit('setSelected', this.value);
            }
          },

          updateValue: function updateValue(value) {
            if (this.type != 'multiselect') { return; }

            var newValue;

            if (this.value.includes(value)) {
              newValue = this.value.filter(function (item) {
                return item !== value;
              });
            } else {
              newValue = this.value.concat(value);
            }

            this.$emit('input', newValue);
          }
        }
      };

    var MODAL_POSITION = "bottom";
    var SUBMENU_POSITION = "right";

    var ContextualMenu$1 = function () {
      function ContextualMenu(container, hostTarget, position) {
        this._container = container;
        this._hostTarget = hostTarget;
        this._position = position ? position : MODAL_POSITION;
        this._isOpen = false;

        this._setOpener(hostTarget);

        this._init();
      }

      ContextualMenu.prototype.getHost = function () {
        return this._host;
      };

      ContextualMenu.prototype._init = function () {
        this._container.addEventListener("click", this._onContextualMenuClick.bind(this), true);

        document.addEventListener("click", this._onDocumentClick.bind(this), false);
      };

      ContextualMenu.prototype._onDocumentClick = function (event) {
        if (event.target instanceof HTMLElement) {
          var target = event.target;
          var classList = target.classList;

          if (!this._hostTarget.contains(target) && !classList.contains("ms-ContextualMenu-link")) {
            this._isOpen = false;
          }
        }
      };

      ContextualMenu.prototype._onContextualMenuClick = function (event) {
        var target = event.target;
        var classList = target.classList;

        if (classList.contains("ms-ContextualMenu-link") && !classList.contains("is-disabled")) {
          if (this._container.classList.contains("ms-ContextualMenu--multiselect")) {
            this._multiSelect(target);
          } else {
            this._singleSelect(target);

            if (!target.parentElement.classList.contains("ms-ContextualMenu-item--hasMenu")) {
              this._host.disposeModal();

              this._isOpen = false;
            }
          }
        }
      };

      ContextualMenu.prototype._multiSelect = function (target) {
        if (target.classList.contains("is-selected")) {
          target.classList.remove("is-selected");
        } else {
          target.classList.add("is-selected");
        }
      };

      ContextualMenu.prototype._singleSelect = function (target) {
        var selecteds = this._container.querySelectorAll(".is-selected");

        var i = selecteds.length;

        while (i--) {
          selecteds[i].classList.remove("is-selected");
        }

        target.classList.add("is-selected");
      };

      ContextualMenu.prototype._toggleMenu = function (event) {
        !this._isOpen ? this._openContextMenu(event) : this._host.disposeModal();
        this._isOpen = !this._isOpen;
      };

      ContextualMenu.prototype._setOpener = function (hostTarget) {
        var _this = this;

        hostTarget.addEventListener("click", function (event) {
          event.preventDefault();

          _this._toggleMenu(event);
        });
      };

      ContextualMenu.prototype._openContextMenu = function (event) {
        this._createModalHostView(this._container, this._position, this._hostTarget);

        this._checkForSubmenus(this._container);
      };

      ContextualMenu.prototype._checkForSubmenus = function (container) {
        var _this = this;

        var submenus = container.querySelectorAll(".ms-ContextualMenu-item.ms-ContextualMenu-item--hasMenu");
        var i = submenus.length;

        if (submenus.length) {
          var _loop_1 = function _loop_1() {
            var button = submenus[i].querySelector(".ms-ContextualMenu-link");
            var menu = submenus[i].querySelector(".ms-ContextualMenu");

            if (menu) {
              var contextualMenu_1 = new ContextualMenu(menu, button, SUBMENU_POSITION);
              menu.addEventListener("hostAdded", function () {
                _this._host.setChildren(contextualMenu_1.getHost());
              });
            }
          };

          while (i--) {
            _loop_1();
          }
        }
      };

      ContextualMenu.prototype._createModalHostView = function (container, position, hostTarget) {
        container.classList.remove("is-hidden");
        this._host = new ContextualHost(container, position, hostTarget, false);
        var event = document.createEvent("Event");
        event.initEvent("hostAdded", true, true);
        container.dispatchEvent(event);
      };

      return ContextualMenu;
    }();

    var ContextualMenuItem = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('li',{staticClass:"ms-ContextualMenu-item",class:_vm.contextualMenuItemClass},[(_vm.type == 'header')?_c('span',[_vm._v(_vm._s(_vm.name))]):_vm._e(),_vm._v(" "),(_vm.hasLink)?_c('a',{staticClass:"ms-ContextualMenu-link",class:_vm.contextualMenuLinkClass,on:{"click":_vm.clickEvent}},[_vm._v(" "+_vm._s(_vm.name)+" ")]):_vm._e(),_vm._v(" "),(_vm.hasMenu)?_c('i',{staticClass:"ms-ContextualMenu-subMenuIcon ms-Icon ms-Icon--ChevronRight"}):_vm._e(),_vm._v(" "),(_vm.hasMenu)?_c('ul',{staticClass:"ms-ContextualMenu is-hidden"},[_vm._t("default")],2):_vm._e()])},staticRenderFns: [],
      name: 'ou-contextual-menu-item',

      mixins: [type('divider', 'header', 'hasMenu'), disabled],

      inject: ['eventHub'],

      data: function data() {
        return {
          selected: false
        };
      },

      props: {
        name: String,
        value: [String, Number]
      },

      computed: {
        hasLink: function hasLink() {
          return this.type == 'hasMenu' || this.type == '';
        },

        hasMenu: function hasMenu() {
          return this.type == 'hasMenu';
        },

        contextualMenuItemClass: function contextualMenuItemClass() {
          var obj;

          return ( obj = {}, obj[("ms-ContextualMenu-item--" + (this.type))] = !!this.type, obj );
        },

        contextualMenuLinkClass: function contextualMenuLinkClass() {
          return {
            'is-disabled': this.disabled,
            'is-selected': this.selected
          };
        }
      },

      created: function created() {
        this.eventHub.$on('setSelected', this.setSelected);
      },

      beforeDestroy: function beforeDestroy() {
        this.eventHub.$off('setSelected', this.setSelected);
      },

      methods: {
        clickEvent: function clickEvent() {
          if (this.value) {
            this.eventHub.$emit('updateValue', this.value);
          } else if (!this.type && !this.disabled) {
            this.$emit('click');
          }
        },

        setSelected: function setSelected(values) {
          if (values.includes(this.value)) {
            this.selected = true;
          } else {
            this.selected = false;
          }
        }
      }
    };

    var SB_FIELD = ".ms-SearchBox-field";
    var SB_CLEAR_BUTTON = ".ms-SearchBox-clear";
    var SB_EXIT_BUTTON = ".ms-SearchBox-exit";
    var SB_HAS_TEXT = "has-text";
    var SB_IS_ACTIVE = "is-active";
    var SB_IS_ANIMATED = "is-animated";

    var SearchBox = function () {
      function SearchBox(container) {
        var _this = this;

        this._container = container;

        this._saveDOMRefs(this._container);

        this._boundExpandSearchHandler = this._expandSearchHandler.bind(this);
        this._boundEnableClose = this._enableClose.bind(this);
        this._boundCollapseSearchBox = this._collapseSearchBox.bind(this);
        this._boundClearSearchBox = this._clearSearchBox.bind(this);
        this._boundHandleBlur = this._handleBlur.bind(this);
        this._boundExitSearchBox = this._exitSearchBox.bind(this);

        this._setHasText();

        this._setFocusAction(this._container);

        this._setClearButtonAction();

        this._setBlurAction();

        this._clearOnly = false;
        setTimeout(function () {
          _this._checkState();

          _this._addAnimation();
        }, 10);
      }

      SearchBox.prototype.setCollapsedListeners = function () {
        this._disposeListeners();

        this._searchBox.addEventListener("click", this._boundExpandSearchHandler, false);

        this._searchBoxField.addEventListener("focus", this._boundExpandSearchHandler, true);
      };

      SearchBox.prototype.getInputField = function () {
        return this._searchBoxField;
      };

      SearchBox.prototype._saveDOMRefs = function (context) {
        this._searchBox = context;
        this._searchBoxField = this._searchBox.querySelector(SB_FIELD);
        this._searchBoxClearButton = this._searchBox.querySelector(SB_CLEAR_BUTTON);
        this._searchBoxExitButton = this._searchBox.querySelector(SB_EXIT_BUTTON);
      };

      SearchBox.prototype._disposeListeners = function () {
        this._searchBox.removeEventListener("click", this._boundExpandSearchHandler);

        this._searchBoxField.removeEventListener("focus", this._boundExpandSearchHandler);
      };

      SearchBox.prototype._exitSearchBox = function (event) {
        event.stopPropagation();
        event.target.blur();

        this._clearSearchBox();

        this._collapseSearchBox();

        this._searchBox.removeEventListener("keyup", this._boundEnableClose);

        this.setCollapsedListeners();
      };

      SearchBox.prototype._collapseSearchBox = function () {
        this._searchBox.classList.remove("is-active");

        var event = document.createEvent("Event");
        event.initEvent("searchCollapse", true, true);

        this._searchBoxField.dispatchEvent(event);
      };

      SearchBox.prototype._expandSearchHandler = function () {
        this._disposeListeners();

        this._searchBox.classList.add("is-active");

        this._searchBoxField.focus();
      };

      SearchBox.prototype._enableClose = function () {
        this._setHasText();
      };

      SearchBox.prototype._setHasText = function () {
        if (this._searchBoxField.value.length > 0) {
          this._searchBox.classList.add(SB_HAS_TEXT);
        } else {
          this._searchBox.classList.remove(SB_HAS_TEXT);
        }
      };

      SearchBox.prototype._setFocusAction = function (context) {
        var _this = this;

        this._searchBoxField.addEventListener("focus", function () {
          _this._setHasText();

          _this._searchBox.addEventListener("keyup", _this._boundEnableClose, false);

          _this._searchBox.classList.add(SB_IS_ACTIVE);

          _this._searchBox.classList.add(SB_IS_ACTIVE);
        }, true);
      };

      SearchBox.prototype._clearSearchBox = function (event) {
        var _this = this;

        this._clearOnly = true;
        this._searchBoxField.value = "";

        this._setHasText();

        setTimeout(function () {
          _this._clearOnly = false;
        }, 10);
      };

      SearchBox.prototype._setClearButtonAction = function () {
        var _this = this;

        if (this._searchBoxExitButton) {
          this._searchBoxExitButton.addEventListener("click", this._boundExitSearchBox, false);
        }

        this._searchBoxClearButton.addEventListener("mousedown", this._boundClearSearchBox, false);

        this._searchBoxClearButton.addEventListener("keydown", function (e) {
          var keyCode = e.keyCode;

          if (keyCode === 13) {
            _this._clearSearchBox(e);
          }
        }, false);
      };

      SearchBox.prototype._handleBlur = function (event) {
        var _this = this;

        console.log("_handleBlur");
        if (this._searchBox.classList.contains("ignoreBlur")) { return; }

        if (!this._clearOnly) {
          this._searchBox.removeEventListener("keyup", this._boundEnableClose);

          setTimeout(function () {
            if (!_this._searchBox.contains(document.activeElement)) {
              _this._clearSearchBox();

              _this._collapseSearchBox();

              _this.setCollapsedListeners();
            }
          }, 10);
        } else {
          this._searchBoxField.focus();
        }

        this._clearOnly = false;
      };

      SearchBox.prototype._setBlurAction = function () {
        this._searchBoxField.addEventListener("blur", this._boundHandleBlur, true);

        this._searchBoxClearButton.addEventListener("blur", this._boundHandleBlur, true);
      };

      SearchBox.prototype._checkState = function () {
        if (this._searchBox.classList.contains("is-collapsed")) {
          this.setCollapsedListeners();
        }
      };

      SearchBox.prototype._addAnimation = function () {
        this._container.classList.add(SB_IS_ANIMATED);
      };

      return SearchBox;
    }();

    var CONTEXT_CLASS = ".ms-ContextualMenu";
    var CB_SPLIT_CLASS = ".ms-CommandButton-splitIcon";
    var CB_BUTTON_CLASS = ".ms-CommandButton-button";
    var MODAL_POSITION$1 = "bottom";

    var CommandButton = function () {
      function CommandButton(container, contextMenu) {
        this._container = container;
        this._command = this._container;
        this._commandButton = this._command.querySelector(CB_BUTTON_CLASS);
        this._splitButton = this._command.querySelector(CB_SPLIT_CLASS);

        if (contextMenu) {
          this._contextualMenu = contextMenu;
        } else {
          this._contextualMenu = this._container.querySelector(CONTEXT_CLASS);
        }

        this._checkForMenu();
      }

      CommandButton.prototype._createModalHostView = function () {
        this._modalHostView = new ContextualHost(this._contextualMenu, MODAL_POSITION$1, this._command, false);
      };

      CommandButton.prototype._setClick = function () {
        if (this._splitButton) {
          this._splitButton.addEventListener("click", this._createModalHostView.bind(this), false);
        } else {
          this._commandButton.addEventListener("click", this._createModalHostView.bind(this), false);
        }
      };

      CommandButton.prototype._checkForMenu = function () {
        if (this._contextualMenu) {
          this._setClick();
        }
      };

      return CommandButton;
    }();

    var CONTEXTUAL_MENU = ".ms-ContextualMenu";
    var CONTEXTUAL_MENU_ITEM = ".ms-ContextualMenu-item";
    var CONTEXTUAL_MENU_LINK = ".ms-ContextualMenu-link";
    var CB_SEARCH_BOX = ".ms-SearchBox";
    var CB_MAIN_AREA = ".ms-CommandBar-mainArea";
    var CB_SIDE_COMMAND_AREA = ".ms-CommandBar-sideCommands";
    var CB_ITEM_OVERFLOW = ".ms-CommandBar-overflowButton";
    var CB_NO_LABEL_CLASS = "ms-CommandButton--noLabel";
    var SEARCH_BOX_CLOSE = ".ms-SearchBox-closeField";
    var COMMAND_BUTTON = ".ms-CommandButton";
    var COMMAND_BUTTON_LABEL = ".ms-CommandButton-label";
    var ICON = ".ms-Icon";
    var OVERFLOW_WIDTH = 40;
    var OVERFLOW_LEFT_RIGHT_PADDING = 30;

    var CommandBar = function () {
      function CommandBar(container) {
        this.responsiveSizes = {
          "sm-min": 320,
          "md-min": 480,
          "lg-min": 640,
          "xl-min": 1024,
          "xxl-min": 1366,
          "xxxl-min": 1920
        };
        this.visibleCommands = [];
        this.commandWidths = [];
        this.overflowCommands = [];
        this.itemCollection = [];
        this._sideAreaCollection = [];
        this.breakpoint = "sm";
        this._container = container;
        this.responsiveSizes["sm-max"] = this.responsiveSizes["md-min"] - 1;
        this.responsiveSizes["md-max"] = this.responsiveSizes["lg-min"] - 1;
        this.responsiveSizes["lg-max"] = this.responsiveSizes["xl-min"] - 1;
        this.responsiveSizes["xl-max"] = this.responsiveSizes["xxl-min"] - 1;
        this.responsiveSizes["xxl-max"] = this.responsiveSizes["xxxl-min"] - 1;

        this._setElements();

        this._setBreakpoint();

        if (this._elements.overflowCommand) {
          this._initOverflow();
        }

        this._setUIState();
      }

      CommandBar.prototype._runsSearchBox = function (state) {
        if (state === void 0) {
          state = "add";
        }

        this._changeSearchState("is-collapsed", state);
      };

      CommandBar.prototype._runOverflow = function () {
        if (this._elements.overflowCommand) {
          this._saveCommandWidths();

          this._redrawMenu();

          this._updateCommands();

          this._drawCommands();

          this._checkOverflow();
        }
      };

      CommandBar.prototype._initOverflow = function () {
        this._createContextualRef();

        this._createItemCollection(this.itemCollection, CB_MAIN_AREA);

        this._createItemCollection(this._sideAreaCollection, CB_SIDE_COMMAND_AREA);

        this._saveCommandWidths();

        this._updateCommands();

        this._drawCommands();

        this._setWindowEvent();

        this._checkOverflow();
      };

      CommandBar.prototype._hasClass = function (element, cls) {
        return (" " + element.className + " ").indexOf(" " + cls + " ") > -1;
      };

      CommandBar.prototype._onSearchExpand = function () {
        if (this.breakpoint === "lg") {
          this._container.classList.add("search-expanded");

          this._doResize();
        }
      };

      CommandBar.prototype._onSearchCollapse = function () {
        if (this.breakpoint === "lg") {
          this._container.classList.remove("search-expanded");

          this._doResize();
        }
      };

      CommandBar.prototype._getScreenSize = function () {
        var w = window;
        var wSize = {
          x: 0,
          y: 0
        };
        var d = document,
            e = d.documentElement,
            g = d.getElementsByTagName("body")[0];
        wSize.x = w.innerWidth || e.clientWidth || g.clientWidth;
        wSize.y = w.innerHeight || e.clientHeight || g.clientHeight;
        return wSize;
      };

      CommandBar.prototype._setBreakpoint = function () {
        var screenSize = this._getScreenSize().x;

        switch (true) {
          case screenSize <= this.responsiveSizes["sm-max"]:
            this.breakpoint = "sm";
            break;

          case screenSize >= this.responsiveSizes["md-min"] && screenSize <= this.responsiveSizes["md-max"]:
            this.breakpoint = "md";
            break;

          case screenSize >= this.responsiveSizes["lg-min"] && screenSize <= this.responsiveSizes["lg-max"]:
            this.breakpoint = "lg";
            break;

          case screenSize >= this.responsiveSizes["xl-min"] && screenSize <= this.responsiveSizes["xl-max"]:
            this.breakpoint = "xl";
            break;

          case screenSize >= this.responsiveSizes["xxl-min"] && screenSize <= this.responsiveSizes["xxl-max"]:
            this.breakpoint = "xxl";
            break;

          case screenSize >= this.responsiveSizes["xxxl-min"]:
            this.breakpoint = "xxxl";
            break;
        }
      };

      CommandBar.prototype._createSearchInstance = function () {
        if (this._elements.searchBox) {
          return new SearchBox(this._elements.searchBox);
        } else {
          return false;
        }
      };

      CommandBar.prototype._changeSearchState = function (state, action) {
        if (this._elements.searchBox) {
          switch (action) {
            case "remove":
              this._elements.searchBox.classList.remove(state);

              break;

            case "add":
              this._elements.searchBox.classList.add(state);

              break;

            default:
              break;
          }
        }
      };

      CommandBar.prototype._setElements = function () {
        var _this = this;

        this._elements = {
          mainArea: this._container.querySelector(CB_MAIN_AREA)
        };

        if (this._container.querySelector(CB_SIDE_COMMAND_AREA)) {
          this._elements.sideCommandArea = this._container.querySelector(CB_SIDE_COMMAND_AREA);
        }

        if (this._container.querySelector(CB_ITEM_OVERFLOW)) {
          this._elements.overflowCommand = this._container.querySelector(CB_ITEM_OVERFLOW);
          this._elements.contextMenu = this._container.querySelector(CB_ITEM_OVERFLOW).querySelector(CONTEXTUAL_MENU);
        }

        if (this._container.querySelector(CB_MAIN_AREA + " " + CB_SEARCH_BOX)) {
          this._elements.searchBox = this._container.querySelector(CB_MAIN_AREA + " " + CB_SEARCH_BOX);
          this._elements.searchBoxClose = this._container.querySelector(SEARCH_BOX_CLOSE);
          this.searchBoxInstance = this._createSearchInstance();
          this.searchBoxInstance.getInputField().addEventListener("focus", function () {
            _this._onSearchExpand();
          }, false);
          this.searchBoxInstance.getInputField().addEventListener("searchCollapse", function () {
            _this._onSearchCollapse();
          }, false);
        }
      };

      CommandBar.prototype._createItemCollection = function (iCollection, areaClass) {
        var item,
            label,
            iconClasses,
            splitClasses,
            items = this._container.querySelectorAll(areaClass + " > " + COMMAND_BUTTON + ":not(" + CB_ITEM_OVERFLOW + ")");

        this._commandButtonInstance = new CommandButton(this._elements.overflowCommand);

        for (var i = 0; i < items.length; i++) {
          item = items[i];
          label = item.querySelector(COMMAND_BUTTON_LABEL).textContent;
          var icon = item.querySelector(ICON);

          if (icon) {
            iconClasses = icon.className;
            splitClasses = iconClasses.split(" ");

            for (var o = 0; o < splitClasses.length; o++) {
              if (splitClasses[o].indexOf(ICON.replace(".", "") + "--") > -1) {
                icon = splitClasses[o];
                break;
              }
            }
          }

          iCollection.push({
            item: item,
            label: label,
            icon: icon,
            isCollapsed: item.classList.contains(CB_NO_LABEL_CLASS) ? true : false,
            commandButtonRef: new CommandButton(item)
          });
        }

        return;
      };

      CommandBar.prototype._createContextualRef = function () {
        this.contextualItemContainerRef = this._elements.contextMenu.querySelector(CONTEXTUAL_MENU_ITEM).cloneNode(true);
        this.contextualItemLink = this._elements.contextMenu.querySelector(CONTEXTUAL_MENU_LINK).cloneNode(false);
        this.contextualItemIcon = this._elements.contextMenu.querySelector(".ms-Icon").cloneNode(false);
        this._elements.contextMenu.innerHTML = "";
      };

      CommandBar.prototype._getElementWidth = function (element) {
        var width, styles;

        if (element.offsetParent === null) {
          element.setAttribute("style", "position: absolute; opacity: 0; display: block;");
        }

        width = element.getBoundingClientRect().width;
        styles = window.getComputedStyle(element);
        width += parseInt(styles.marginLeft, 10) + parseInt(styles.marginRight, 10);
        element.setAttribute("style", "");
        return width;
      };

      CommandBar.prototype._saveCommandWidths = function () {
        var this$1 = this;

        for (var i = 0; i < this.itemCollection.length; i++) {
          var item = this$1.itemCollection[i].item;

          var width = this$1._getElementWidth(item);

          this$1.commandWidths[i] = width;
        }
      };

      CommandBar.prototype._updateCommands = function () {
        var this$1 = this;

        var searchCommandWidth = 0;

        var mainAreaWidth = this._elements.mainArea.getBoundingClientRect().width;

        if (this._elements.searchBox) {
          searchCommandWidth = this._getElementWidth(this._elements.searchBox);
        }

        var offset = searchCommandWidth + OVERFLOW_WIDTH + OVERFLOW_LEFT_RIGHT_PADDING;
        var totalAreaWidth = mainAreaWidth - offset;
        this.visibleCommands = [];
        this.overflowCommands = [];
        var totalWidths = 0;

        for (var i = 0; i < this.itemCollection.length; i++) {
          totalWidths += this$1.commandWidths[i];

          if (totalWidths < totalAreaWidth) {
            this$1.visibleCommands.push(this$1.itemCollection[i]);
          } else {
            this$1.overflowCommands.push(this$1.itemCollection[i]);
          }
        }
      };

      CommandBar.prototype._drawCommands = function () {
        var this$1 = this;

        this._elements.contextMenu.innerHTML = "";

        for (var i = 0; i < this.overflowCommands.length; i++) {
          this$1.overflowCommands[i].item.classList.add("is-hidden");
          var newCItem = this$1.contextualItemContainerRef.cloneNode(false);
          var newClink = this$1.contextualItemLink.cloneNode(false);
          var iconClass = this$1.overflowCommands[i].icon;
          newClink.innerText = this$1.overflowCommands[i].label;
          newCItem.appendChild(newClink);

          if (iconClass) {
            var newIcon = this$1.contextualItemIcon.cloneNode(false);
            newIcon.className = ICON.replace(".", "") + " " + iconClass;
            newCItem.appendChild(newIcon);
          }

          this$1._elements.contextMenu.appendChild(newCItem);
        }

        for (var x = 0; x < this.visibleCommands.length; x++) {
          this$1.visibleCommands[x].item.classList.remove("is-hidden");
        }
      };

      CommandBar.prototype._setWindowEvent = function () {
        var _this = this;

        window.addEventListener("resize", function () {
          _this._doResize();
        }, false);
      };

      CommandBar.prototype._processCollapsedClasses = function (type) {
        var this$1 = this;

        for (var i = 0; i < this.itemCollection.length; i++) {
          var thisItem = this$1.itemCollection[i];

          if (!thisItem.isCollapsed) {
            if (type === "add") {
              thisItem.item.classList.add(CB_NO_LABEL_CLASS);
            } else {
              thisItem.item.classList.remove(CB_NO_LABEL_CLASS);
            }
          }
        }

        for (var i = 0; i < this._sideAreaCollection.length; i++) {
          var thisItem = this$1._sideAreaCollection[i];

          if (!thisItem.isCollapsed) {
            if (type === "add") {
              thisItem.item.classList.add(CB_NO_LABEL_CLASS);
            } else {
              thisItem.item.classList.remove(CB_NO_LABEL_CLASS);
            }
          }
        }
      };

      CommandBar.prototype._setUIState = function () {
        switch (this.breakpoint) {
          case "sm":
            this._runsSearchBox();

            this._processCollapsedClasses("add");

            this._runOverflow();

            break;

          case "md":
            this._runsSearchBox();

            this._processCollapsedClasses("add");

            this._runOverflow();

            break;

          case "lg":
            this._runsSearchBox();

            this._processCollapsedClasses("remove");

            this._runOverflow();

            break;

          case "xl":
            this._runsSearchBox("remove");

            this._processCollapsedClasses("remove");

            this._runOverflow();

            break;

          default:
            this._runsSearchBox("remove");

            this._processCollapsedClasses("remove");

            this._runOverflow();

            break;
        }
      };

      CommandBar.prototype._checkOverflow = function () {
        if (this.overflowCommands.length > 0) {
          this._elements.overflowCommand.classList.remove("is-hidden");
        } else {
          this._elements.overflowCommand.classList.add("is-hidden");

          if (this.activeCommand === this._elements.overflowCommand) {
            this._elements.contextMenu.classList.remove("is-open");
          }
        }
      };

      CommandBar.prototype._redrawMenu = function () {
        var left;

        if (this._hasClass(this._elements.contextMenu, "is-open")) {
          left = this.activeCommand.getBoundingClientRect().left;

          this._drawOverflowMenu(left);
        }
      };

      CommandBar.prototype._drawOverflowMenu = function (left) {
        this._elements.contextMenu.setAttribute("style", "left: " + left + "px; transform: translateX(-50%)");
      };

      CommandBar.prototype._doResize = function () {
        this._setBreakpoint();

        this._setUIState();
      };

      return CommandBar;
    }();

    var commandbutton = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"ms-CommandButton",class:_vm.commandButtonClass,on:{"click":_vm.clickEvent}},[_c('button',{staticClass:"ms-CommandButton-button"},[(_vm.icon)?_c('span',{staticClass:"ms-CommandButton-icon ms-fontColor-themePrimary"},[_c('i',{staticClass:"ms-Icon",class:_vm.iconClass})]):_vm._e(),_vm._v(" "),_c('span',{staticClass:"ms-CommandButton-label"},[_vm._t("default")],2),_vm._v(" "),(_vm.type == 'dropdown')?_c('span',{staticClass:"ms-CommandButton-dropdownIcon"},[_c('i',{staticClass:"ms-Icon ms-Icon--ChevronDown"})]):_vm._e()])])},staticRenderFns: [],
      name: 'ou-command-button',

      mixins: [
        type('noLabel', 'inline', 'dropdown'),
        disabled,
        icon
      ],

      computed: {
        commandButtonClass: function commandButtonClass() {
          var obj;

          return ( obj = {}, obj[("ms-CommandButton--" + (this.type))] = !!this.type, obj['is-disabled'] =  this.disabled, obj );
        }
      },

      methods: {
        clickEvent: function clickEvent() {
          if (!this.disabled) { this.$emit('click'); }
        }
      }
    };

    var CONTEXT_CLASS$1 = ".ms-ContextualMenu";
    var CB_SPLIT_CLASS$1 = ".ms-CommandButton-splitIcon";
    var CB_BUTTON_CLASS$1 = ".ms-CommandButton-button";
    var MODAL_POSITION$2 = "bottom";

    var CommandButton$1 = function () {
      function CommandButton(container, contextMenu) {
        this._container = container;
        this._command = this._container;
        this._commandButton = this._command.querySelector(CB_BUTTON_CLASS$1);
        this._splitButton = this._command.querySelector(CB_SPLIT_CLASS$1);

        if (contextMenu) {
          this._contextualMenu = contextMenu;
        } else {
          this._contextualMenu = this._container.querySelector(CONTEXT_CLASS$1);
        }

        this._checkForMenu();
      }

      CommandButton.prototype._createModalHostView = function () {
        this._modalHostView = new ContextualHost(this._contextualMenu, MODAL_POSITION$2, this._command, false);
      };

      CommandButton.prototype._setClick = function () {
        if (this._splitButton) {
          this._splitButton.addEventListener("click", this._createModalHostView.bind(this), false);
        } else {
          this._commandButton.addEventListener("click", this._createModalHostView.bind(this), false);
        }
      };

      CommandButton.prototype._checkForMenu = function () {
        if (this._contextualMenu) {
          this._setClick();
        }
      };

      return CommandButton;
    }();

    var dialog = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"dialog",staticClass:"ms-Dialog",class:_vm.dialogClass},[(_vm.type == 'close')?_c('button',{staticClass:"ms-Dialog-button ms-Dialog-buttonClose",on:{"click":_vm.closeDialog}},[_c('i',{staticClass:"ms-Icon ms-Icon--Cancel"})]):_vm._e(),_vm._v(" "),_c('div',{staticClass:"ms-Dialog-title"},[_vm._v(_vm._s(_vm.title))]),_vm._v(" "),_c('div',{staticClass:"ms-Dialog-content"},[_c('p',{staticClass:"ms-Dialog-subText"},[_vm._v(_vm._s(_vm.subText))]),_vm._v(" "),_vm._t("default")],2),_vm._v(" "),_c('div',{staticClass:"ms-Dialog-actions"},[_vm._t("actions")],2)])},staticRenderFns: [],
      name: 'ou-dialog',

      mixins: [type('multiline', 'lgHeader', 'blocking', 'close')],

      props: {
        title: String,
        subText: String,

        value: {
          type: Boolean,
          default: false
        }
      },

      data: function data() {
        return {
          dialogInstance: null
        };
      },

      computed: {
        dialogClass: function dialogClass() {
          var obj;

          return ( obj = {}, obj[("ms-Dialog--" + (this.type))] = !!this.type, obj );
        }
      },

      watch: {
        value: function value(value$1) {
          this.setDialogVisibility(value$1);
        }
      },

      mounted: function mounted() {
        this.dialogInstance = new this.$fabric.Dialog(this.$refs.dialog);
        this.setDialogVisibility(this.value);
      },

      methods: {
        setDialogVisibility: function setDialogVisibility(value) {
          if (value) {
            this.dialogInstance.open();

            // Because the office ui fabric js don't support on_close or on_open event in dialog
            // component, So I have to write some hacking code to change the visible status when
            // click the overlay. Otherwise the visible status can't change, when click the overlay
            // to close the dialog.
            this.bindOverlayCloseEvent();
          } else if (this.isOpen()) {
            // Avoid to destroy overlay element twice, and get errors, so determine if the dialog
            // was opened before close it.
            this.dialogInstance.close();
          }
        },

        bindOverlayCloseEvent: function bindOverlayCloseEvent() {
          var this$1 = this;

          if (this.dialogInstance._overlay) {
            var overlayElement = this.dialogInstance._overlay.overlayElement;

            var closeOverlay = function () {
              overlayElement.removeEventListener('click', closeOverlay);
              this$1.$emit('input', false);
            };

            overlayElement.addEventListener('click', closeOverlay);
          }
        },

        isOpen: function isOpen() {
          // When the dialog is shown, the dialog element add a class name of 'is-open',
          // So use this to determine the dialog if was opened.
          return this.$refs.dialog.classList.contains('is-open');
        },

        closeDialog: function closeDialog(event) {
          this.$emit('input', false);


          // Because the original close button element have the click event to close the dialog,
          // when I fire the click event, the original click event function will fire behind it,
          // So stop the original click event, when I fire the click event.
          event.stopImmediatePropagation();
        }
      }
    };

    var Overlay = function () {
      function Overlay(overlayElement) {
        if (overlayElement) {
          this.overlayElement = overlayElement;
        } else {
          var overlayContainer = document.createElement("div");
          overlayContainer.setAttribute("class", "ms-Overlay");
          this.overlayElement = overlayContainer;
        }

        this.overlayElement.addEventListener("click", this.hide.bind(this), false);
      }

      Overlay.prototype.remove = function () {
        this.overlayElement.parentElement.removeChild(this.overlayElement);
      };

      Overlay.prototype.show = function () {
        this.overlayElement.classList.add("is-visible");
        document.body.classList.add("ms-u-overflowHidden");
      };

      Overlay.prototype.hide = function () {
        this.overlayElement.classList.remove("is-visible");
        document.body.classList.remove("ms-u-overflowHidden");
      };

      return Overlay;
    }();

    var Dialog = function () {
      function Dialog(dialog) {
        var this$1 = this;

        this._dialog = dialog;
        this._closeButtonElement = this._dialog.querySelector(".ms-Dialog-buttonClose");
        this._actionButtonElements = this._dialog.querySelectorAll(".ms-Dialog-action");

        if (this._closeButtonElement) {
          this._closeButtonElement.addEventListener("click", this.close.bind(this), false);
        }

        for (var i = 0; i < this._actionButtonElements.length; i++) {
          this$1._actionButtonElements[i].addEventListener("click", this$1.close.bind(this$1), false);
        }
      }

      Dialog.prototype.close = function () {
        this._overlay.remove();

        this._dialog.classList.remove("is-open");

        document.body.classList.remove("ms-u-overflowHidden");

        this._overlay.overlayElement.removeEventListener("click", this.close.bind(this));
      };

      Dialog.prototype.open = function () {
        this._dialog.classList.add("is-open");

        this._overlay = new Overlay();

        if (!this._dialog.classList.contains("ms-Dialog--blocking")) {
          this._overlay.overlayElement.addEventListener("click", this.close.bind(this), false);

          this._overlay.show();

          document.body.classList.add("ms-u-overflowHidden");
        }

        this._dialog.parentElement.appendChild(this._overlay.overlayElement);
      };

      return Dialog;
    }();

    var PANEL_HOST_CLASS = "ms-PanelHost";

    var PanelHost = function () {
      function PanelHost(layer, callBack) {
        this._layer = layer;
        this._callBack = callBack;

        this._createElements();

        this._renderElements();
      }

      PanelHost.prototype.dismiss = function () {
        this.overlay.hide();
        document.body.removeChild(this.panelHost);
      };

      PanelHost.prototype.update = function (layer, callBack) {
        this.panelHost.replaceChild(layer, this._layer);

        if (callBack) {
          callBack();
        }
      };

      PanelHost.prototype._renderElements = function () {
        document.body.appendChild(this.panelHost);

        if (this._callBack) {
          this._callBack(this._layer);
        }
      };

      PanelHost.prototype._createElements = function () {
        this.panelHost = document.createElement("div");
        this.panelHost.classList.add(PANEL_HOST_CLASS);
        this.panelHost.appendChild(this._layer);
        this.overlay = new Overlay(this._overlayContainer);
        this.overlay.show();
        this.panelHost.appendChild(this.overlay.overlayElement);
      };

      return PanelHost;
    }();

    var ANIMATE_IN_STATE = "animate-in";
    var ANIMATE_OUT_STATE = "animate-out";
    var ANIMATION_END = 400;

    var Panel = function () {
      function Panel(panel, direction, animateOverlay) {
        this._panel = panel;
        this._direction = direction || "right";
        this._animateOverlay = animateOverlay || true;
        this.panelHost = new PanelHost(this._panel, this._animateInPanel);
        this._closeButton = this._panel.querySelector(".ms-PanelAction-close");
        this._clickHandler = this.dismiss.bind(this, null);

        this._setEvents();

        document.body.setAttribute("style", "height: 100%; overflow: hidden;");
      }

      Panel.prototype.dismiss = function (callBack) {
        var _this = this;

        this._panel.classList.add(ANIMATE_OUT_STATE);

        setTimeout(function () {
          _this._panel.classList.remove(ANIMATE_OUT_STATE);

          _this._panel.classList.remove("is-open");

          _this.panelHost.dismiss();

          if (callBack) {
            callBack();
          }

          document.body.setAttribute("style", "");
        }, ANIMATION_END);

        if (this._closeButton !== null) {
          this._closeButton.removeEventListener("click", this._clickHandler);
        }
      };

      Panel.prototype._setEvents = function () {
        this.panelHost.overlay.overlayElement.addEventListener("click", this._clickHandler);

        if (this._closeButton !== null) {
          this._closeButton.addEventListener("click", this._clickHandler);
        }
      };

      Panel.prototype._animateInPanel = function (layer) {
        layer.classList.add(ANIMATE_IN_STATE);
        layer.classList.add("is-open");
        setTimeout(function () {
          layer.classList.remove(ANIMATE_IN_STATE);
        }, ANIMATION_END);
      };

      return Panel;
    }();

    var DROPDOWN_CLASS = "ms-Dropdown";
    var DROPDOWN_TITLE_CLASS = "ms-Dropdown-title";
    var DROPDOWN_LABEL_HELPER = "ms-Dropdown-truncator";
    var DROPDOWN_ITEMS_CLASS = "ms-Dropdown-items";
    var DROPDOWN_ITEM_CLASS = "ms-Dropdown-item";
    var DROPDOWN_SELECT_CLASS_SELECTOR = ".ms-Dropdown-select";
    var PANEL_CLASS = "ms-Panel";
    var IS_OPEN_CLASS = "is-open";
    var IS_DISABLED_CLASS = "is-disabled";
    var IS_SELECTED_CLASS = "is-selected";
    var ANIMATE_IN_CLASS = "animate-in";
    var SMALL_MAX_WIDTH = 479;

    var Dropdown$1 = function () {
      function Dropdown(container) {
        var this$1 = this;

        this._container = container;
        this._dropdownLabelHelper = document.createElement("span");

        this._dropdownLabelHelper.classList.add(DROPDOWN_LABEL_HELPER);

        this._dropdownLabelHelper.classList.add(DROPDOWN_TITLE_CLASS);

        this._newDropdownLabel = document.createElement("span");

        this._newDropdownLabel.classList.add(DROPDOWN_TITLE_CLASS);

        this._newDropdown = document.createElement("ul");

        this._newDropdown.classList.add(DROPDOWN_ITEMS_CLASS);

        this._dropdownItems = [];
        this._originalDropdown = container.querySelector(DROPDOWN_SELECT_CLASS_SELECTOR);

        var _originalOptions = this._originalDropdown.querySelectorAll("option");

        this._onCloseDropdown = this._onCloseDropdown.bind(this);
        this._onItemSelection = this._onItemSelection.bind(this);
        this._onOpenDropdown = this._onOpenDropdown.bind(this);

        for (var i = 0; i < _originalOptions.length; ++i) {
          var option = _originalOptions[i];

          if (option.selected) {
            this$1._newDropdownLabel.innerHTML = option.text;
          }

          var newItem = document.createElement("li");
          newItem.classList.add(DROPDOWN_ITEM_CLASS);

          if (option.disabled) {
            newItem.classList.add(IS_DISABLED_CLASS);
          }

          if (option.selected) {
            newItem.classList.add(IS_SELECTED_CLASS);
          }

          newItem.innerHTML = option.text;
          newItem.addEventListener("click", this$1._onItemSelection);

          this$1._newDropdown.appendChild(newItem);

          this$1._dropdownItems.push({
            oldOption: option,
            newItem: newItem
          });
        }

        container.appendChild(this._newDropdownLabel);
        container.appendChild(this._newDropdown);
        container.appendChild(this._dropdownLabelHelper);

        this._newDropdownLabel.addEventListener("click", this._onOpenDropdown);

        this._checkTruncation();

        this._setWindowEvent();
      }

      Dropdown.prototype._setWindowEvent = function () {
        var _this = this;

        window.addEventListener("resize", function () {
          _this._doResize();

          _this._checkTruncation();
        }, false);
      };

      Dropdown.prototype._checkTruncation = function () {
        var this$1 = this;

        var selected = this._newDropdown.querySelector("." + IS_SELECTED_CLASS);

        var origText = selected ? selected.textContent : this._newDropdown.querySelectorAll("." + DROPDOWN_ITEM_CLASS)[0].textContent;
        this._dropdownLabelHelper.textContent = origText;

        if (this._dropdownLabelHelper.offsetHeight > this._newDropdownLabel.offsetHeight) {
          var i = 0;
          var ellipsis = "...";
          var newText = void 0;

          do {
            i--;
            newText = origText.slice(0, i);
            this$1._dropdownLabelHelper.textContent = newText + ellipsis;
          } while (this._dropdownLabelHelper.offsetHeight > this._newDropdownLabel.offsetHeight);
        }

        this._newDropdownLabel.textContent = this._dropdownLabelHelper.textContent;
      };

      Dropdown.prototype._getScreenSize = function () {
        var w = window;
        var wSize = {
          x: 0,
          y: 0
        };
        var d = document,
            e = d.documentElement,
            g = d.getElementsByTagName("body")[0];
        wSize.x = w.innerWidth || e.clientWidth || g.clientWidth;
        wSize.y = w.innerHeight || e.clientHeight || g.clientHeight;
        return wSize;
      };

      Dropdown.prototype._doResize = function () {
        var isOpen = this._container.classList.contains(IS_OPEN_CLASS);

        if (!isOpen) {
          return;
        }

        var screenSize = this._getScreenSize().x;

        if (screenSize <= SMALL_MAX_WIDTH) {
          this._openDropdownAsPanel();
        } else {
          this._removeDropdownAsPanel();
        }
      };

      Dropdown.prototype._openDropdownAsPanel = function () {
        if (this._panel === undefined) {
          this._panelContainer = document.createElement("div");

          this._panelContainer.classList.add(PANEL_CLASS);

          this._panelContainer.classList.add(DROPDOWN_CLASS);

          this._panelContainer.classList.add(IS_OPEN_CLASS);

          this._panelContainer.classList.add(ANIMATE_IN_CLASS);

          this._panelContainer.appendChild(this._newDropdown);

          this._panel = new Panel(this._panelContainer);
        }
      };

      Dropdown.prototype._removeDropdownAsPanel = function (evt) {
        var _this = this;

        if (this._panel !== undefined) {
          if (evt && evt.target === this._panel.panelHost.overlay.overlayElement) {
            this._container.appendChild(this._newDropdown);
          } else {
            this._panel.dismiss(function () {
              _this._container.appendChild(_this._newDropdown);
            });
          }

          this._panel = undefined;
        }
      };

      Dropdown.prototype._onOpenDropdown = function (evt) {
        var isDisabled = this._container.classList.contains(IS_DISABLED_CLASS);

        var isOpen = this._container.classList.contains(IS_OPEN_CLASS);

        if (!isDisabled && !isOpen) {
          evt.stopPropagation();

          this._closeOtherDropdowns();

          this._container.classList.add(IS_OPEN_CLASS);

          document.addEventListener("click", this._onCloseDropdown);

          var screenSize = this._getScreenSize().x;

          if (screenSize <= SMALL_MAX_WIDTH) {
            this._openDropdownAsPanel();
          }
        }
      };

      Dropdown.prototype._closeOtherDropdowns = function () {
        var dropdowns = document.querySelectorAll("." + DROPDOWN_CLASS + "." + IS_OPEN_CLASS);

        for (var i = 0; i < dropdowns.length; i++) {
          dropdowns[i].classList.remove(IS_OPEN_CLASS);
        }
      };

      Dropdown.prototype._onCloseDropdown = function (evt) {
        this._removeDropdownAsPanel(evt);

        this._container.classList.remove(IS_OPEN_CLASS);

        document.removeEventListener("click", this._onCloseDropdown);
      };

      Dropdown.prototype._onItemSelection = function (evt) {
        var this$1 = this;

        var item = evt.target;

        var isDropdownDisabled = this._container.classList.contains(IS_DISABLED_CLASS);

        var isOptionDisabled = item.classList.contains(IS_DISABLED_CLASS);

        if (!isDropdownDisabled && !isOptionDisabled) {
          for (var i = 0; i < this._dropdownItems.length; ++i) {
            if (this$1._dropdownItems[i].newItem === item) {
              this$1._dropdownItems[i].newItem.classList.add(IS_SELECTED_CLASS);

              this$1._dropdownItems[i].oldOption.selected = true;
            } else {
              this$1._dropdownItems[i].newItem.classList.remove(IS_SELECTED_CLASS);

              this$1._dropdownItems[i].oldOption.selected = false;
            }
          }

          this._newDropdownLabel.innerHTML = item.textContent;

          this._checkTruncation();

          var changeEvent = document.createEvent("HTMLEvents");
          changeEvent.initEvent("change", false, true);

          this._originalDropdown.dispatchEvent(changeEvent);
        }
      };

      return Dropdown;
    }();

    var ListItem = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('li',{ref:"listItem",staticClass:"ms-ListItem",class:_vm.listItemClass,on:{"click":_vm.clickEvent}},[(_vm.type == 'image')?_c('img',{staticClass:"ms-ListItem-image",attrs:{"src":_vm.imageSrc}}):_vm._e(),_vm._v(" "),(_vm.primaryText)?_c('span',{staticClass:"ms-ListItem-primaryText"},[_vm._v(_vm._s(_vm.primaryText))]):_vm._e(),_vm._v(" "),(_vm.secondaryText)?_c('span',{staticClass:"ms-ListItem-secondaryText"},[_vm._v(_vm._s(_vm.secondaryText))]):_vm._e(),_vm._v(" "),(_vm.tertiaryText)?_c('span',{staticClass:"ms-ListItem-tertiaryText"},[_vm._v(_vm._s(_vm.tertiaryText))]):_vm._e(),_vm._v(" "),(_vm.metaText)?_c('span',{staticClass:"ms-ListItem-metaText"},[_vm._v(_vm._s(_vm.metaText))]):_vm._e(),_vm._v(" "),(_vm.isSelectable)?_c('div',{staticClass:"ms-ListItem-selectionTarget",on:{"click":function($event){$event.stopPropagation();return _vm.toggle($event)}}}):_vm._e(),_vm._v(" "),_vm._t("default")],2)},staticRenderFns: [],
      name: 'ou-list-item',

      mixins: [type('image', 'document')],

      props: {
        isUnread: Boolean,
        isSelectable: Boolean,
        isUnseen: Boolean,
        value: Boolean,

        imageSrc: String,
        primaryText: String,
        secondaryText: String,
        tertiaryText: String,
        metaText: String
      },

      computed: {
        listItemClass: function listItemClass() {
          var obj;

          return ( obj = {}, obj[("ms-ListItem--" + (this.type))] = !!this.type, obj['is-selectable'] =  this.isSelectable, obj['is-selected'] =  this.value, obj['is-unread'] =  this.isUnread, obj['is-unseen'] =  this.isUnseen, obj );
        }
      },

      methods: {
        toggle: function toggle() {
          if (this.isSelectable) {
            this.$emit('input', !this.value);
          }
        },

        clickEvent: function clickEvent() {
          this.$emit('click');
        }
      }
    };

    var MessageBar = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"ms-MessageBar",class:_vm.messageBarClass},[_c('div',{staticClass:"ms-MessageBar-content"},[(_vm.icon)?_c('div',{staticClass:"ms-MessageBar-icon"},[_c('i',{staticClass:"ms-Icon",class:_vm.iconClass})]):_vm._e(),_vm._v(" "),_c('div',{staticClass:"ms-MessageBar-text"},[_vm._t("default")],2)])])},staticRenderFns: [],
      name: 'ou-message-bar',

      mixins: [
        type('success', 'error', 'blocked', 'warning', 'severeWarning'),
        icon
      ],

      computed: {
        messageBarClass: function messageBarClass() {
          var obj;

          return ( obj = {}, obj[("ms-MessageBar--" + (this.type))] = !!this.type, obj );
        }
      }
    };

    var overlay = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"overlay",staticClass:"ms-Overlay",class:_vm.overlayClass})},staticRenderFns: [],
      name: 'ou-overlay',

      mixins: [type('dark')],

      props: {
        value: Boolean
      },

      data: function data() {
        return {
          overlayInstance: null
        };
      },

      watch: {
        value: function value() {
          this.setOverlayVisibility();
        }
      },

      computed: {
        overlayClass: function overlayClass() {
          var obj;

          return ( obj = {}, obj[("ms-Overlay--" + (this.type))] = !!this.type, obj );
        }
      },

      mounted: function mounted() {
        this.overlayInstance = new this.$fabric.Overlay(this.$refs.overlay);

        this.setOverlayVisibility();
        this.bindOverlayCloseEvent();
      },

      methods: {
        setOverlayVisibility: function setOverlayVisibility() {
          this.value ? this.overlayInstance.show() : this.overlayInstance.hide();
        },

        bindOverlayCloseEvent: function bindOverlayCloseEvent() {
          var this$1 = this;

          // Because the overlay component don't have callback when overlay closed,
          // So add a click event when click the overlay to set the value to false
          var overlayElement = this.$refs.overlay;
          var closeOverlay = function () {
            this$1.$emit('input', false);
          };

          overlayElement.addEventListener('click', closeOverlay);
        }
      }
    };

    function size () {
      var arguments$1 = arguments;

      for (var _len = arguments.length, size = new Array(_len), _key = 0; _key < _len; _key++) {
        size[_key] = arguments$1[_key];
      }

      size.push('');
      return {
        props: {
          size: {
            type: String,
            default: '',
            validator: function validator(value) {
              return size.indexOf(value) !== -1;
            }
          }
        }
      };
    }

    var panel = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"panel",staticClass:"ms-Panel",class:_vm.panelClass},[_c('button',{staticClass:"ms-Panel-closeButton ms-PanelAction-close",on:{"click":_vm.closePanel}},[_c('i',{staticClass:"ms-Panel-closeIcon ms-Icon ms-Icon--Cancel"})]),_vm._v(" "),_c('div',{staticClass:"ms-Panel-contentInner"},[_c('p',{staticClass:"ms-Panel-headerText"},[_vm._v(_vm._s(_vm.title))]),_vm._v(" "),_c('div',{staticClass:"ms-Panel-content"},[_vm._t("default")],2)])])},staticRenderFns: [],
      name: 'ou-panel',

      mixins: [size('md', 'lg', 'xl', 'xxl')],

      props: {
        value: Boolean,
        title: String,

        fixed: {
          type: Boolean,
          default: false
        },

        left: {
          type: Boolean,
          default: false
        },

        block: {
          type: Boolean,
          default: false
        }
      },

      data: function data() {
        return {
          panelInstance: null
        };
      },

      watch: {
        value: function value() {
          this.setPanelVisibility();
        }
      },

      computed: {
        panelClass: function panelClass() {
          var obj;

          return ( obj = {}, obj[("ms-Panel--" + (this.size))] = !!this.size, obj['ms-Panel--fixed'] =  this.fixed, obj['ms-Panel--left'] =  this.left, obj );
        }
      },

      mounted: function mounted() {
        this.setPanelVisibility();
      },

      methods: {
        setPanelVisibility: function setPanelVisibility() {
          if (this.value) {
            this.panelInstance = new this.$fabric.Panel(this.$refs.panel);
            this.bindOverlayCloseEvent();
          } else if (this.panelInstance) {
            this.panelInstance.dismiss();
          }
        },

        // Because the office ui fabric js don't support on_close or on_open event in panel
        // component, So I have to write some hacking code to change the visible status when
        // click the overlay. Otherwise the visible status can't change, when click the overlay
        // to close the panel.
        bindOverlayCloseEvent: function bindOverlayCloseEvent() {
          var overlayElement = this.panelInstance.panelHost.overlay.overlayElement;

          if (this.block) {
            // Remove overlayElement to avoid close panel when click overlay.
            overlayElement.remove();
          } else {
            overlayElement.addEventListener('click', this.closePanel);
          }
        },

        closePanel: function closePanel() {
          this.$emit('input', false);

          // Because the panel overlay have event to fire dismiss method when click it to
          // close panel. To prevent fire the panel dismiss method again and raise some error,
          // so set the panelInstance to null
          this.panelInstance = null;
        }
      }
    };

    var ANIMATE_IN_STATE$1 = "animate-in";
    var ANIMATE_OUT_STATE$1 = "animate-out";
    var ANIMATION_END$1 = 400;

    var Panel$1 = function () {
      function Panel(panel, direction, animateOverlay) {
        this._panel = panel;
        this._direction = direction || "right";
        this._animateOverlay = animateOverlay || true;
        this.panelHost = new PanelHost(this._panel, this._animateInPanel);
        this._closeButton = this._panel.querySelector(".ms-PanelAction-close");
        this._clickHandler = this.dismiss.bind(this, null);

        this._setEvents();

        document.body.setAttribute("style", "height: 100%; overflow: hidden;");
      }

      Panel.prototype.dismiss = function (callBack) {
        var _this = this;

        this._panel.classList.add(ANIMATE_OUT_STATE$1);

        setTimeout(function () {
          _this._panel.classList.remove(ANIMATE_OUT_STATE$1);

          _this._panel.classList.remove("is-open");

          _this.panelHost.dismiss();

          if (callBack) {
            callBack();
          }

          document.body.setAttribute("style", "");
        }, ANIMATION_END$1);

        if (this._closeButton !== null) {
          this._closeButton.removeEventListener("click", this._clickHandler);
        }
      };

      Panel.prototype._setEvents = function () {
        this.panelHost.overlay.overlayElement.addEventListener("click", this._clickHandler);

        if (this._closeButton !== null) {
          this._closeButton.addEventListener("click", this._clickHandler);
        }
      };

      Panel.prototype._animateInPanel = function (layer) {
        layer.classList.add(ANIMATE_IN_STATE$1);
        layer.classList.add("is-open");
        setTimeout(function () {
          layer.classList.remove(ANIMATE_IN_STATE$1);
        }, ANIMATION_END$1);
      };

      return Panel;
    }();

    var persona = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"ms-Persona",class:_vm.personaClass},[_c('div',{staticClass:"ms-Persona-imageArea"},[(!_vm.initials)?_c('img',{staticClass:"ms-Persona-image",attrs:{"src":_vm.src}}):_c('div',{staticClass:"ms-Persona-initials",class:_vm.initialsPersonaClass},[_vm._v(_vm._s(_vm.initials.toUpperCase()))])]),_vm._v(" "),(_vm.type)?_c('div',{staticClass:"ms-Persona-presence"},[_c('i',{staticClass:"ms-Persona-presenceIcon ms-Icon",class:_vm.personaIconClass})]):_vm._e(),_vm._v(" "),_c('div',{staticClass:"ms-Persona-details"},[_c('div',{staticClass:"ms-Persona-primaryText"},[_vm._v(_vm._s(_vm.primaryText))]),_vm._v(" "),_c('div',{staticClass:"ms-Persona-secondaryText"},[_vm._v(_vm._s(_vm.secondaryText))]),_vm._v(" "),_c('div',{staticClass:"ms-Persona-tertiaryText"},[_vm._v(_vm._s(_vm.tertiaryText))]),_vm._v(" "),_c('div',{staticClass:"ms-Persona-optionalText"},[_vm._v(_vm._s(_vm.optionalText))])])])},staticRenderFns: [],
      name: 'ou-persona',

      mixins: [
        size('tiny', 'xs', 'sm', 'lg', 'xl'),
        type('available', 'away', 'blocked', 'busy', 'dnd', 'offline')
      ],

      data: function data() {
        if (this.initials) {
          var validateColor = [
            'blue',
            'blueLight',
            'blueDark',
            'teal',
            'greenLight',
            'green',
            'greenDark',
            'magentaLight',
            'magenta',
            'purpleLight',
            'purple',
            'black',
            'orange',
            'red',
            'redDark'
          ];

          var initialsLetter = this.initials[0].toUpperCase();
          var initialsIndex = initialsLetter.charCodeAt() - 65;

          // get radom color from validateColor
          return {
            initialsColor: validateColor[Math.round((validateColor.length / 26) * initialsIndex)]
          };
        }

        return { initialsColor: '' };
      },

      props: {
        src: String,
        initials: String,
        primaryText: String,
        secondaryText: String,
        tertiaryText: String,
        optionalText: String
      },

      computed: {
        personaClass: function personaClass() {
          var obj;

          return ( obj = {}, obj[("ms-Persona--" + (this.size))] = !!this.size, obj[("ms-Persona--" + (this.type))] = !!this.type, obj );
        },

        initialsPersonaClass: function initialsPersonaClass() {
          var obj;

          return ( obj = {}, obj[("ms-Persona-initials--" + (this.initialsColor))] = !!this.initialsColor, obj );
        },

        personaIconClass: function personaIconClass() {
          var icon = '';

          switch (this.type) {
            case 'available':
              icon = 'SkypeCheck';
              break;
            case 'away':
              icon = 'SkypeClock';
              break;
            case 'dnd':
              icon = 'SkypeMinus';
              break;
          }

          if (icon) {
            return ("ms-Icon--" + icon);
          }
        }
      }
    };

    var SCROLL_FRAME_RATE = 33;

    var Animate = function () {
      function Animate() {}

      Animate.transition = function (element, props) {
        var obj = {
          element: element,
          props: props,
          transformations: {}
        };

        Animate._animationObjects.push(obj);

        Animate._parseProperties(obj);

        Animate._createTransition(obj);

        setTimeout(Animate._setProperties, 0, obj);

        Animate._setCallback(obj);
      };

      Animate.animation = function (element, keyframes$$1, props) {
        var obj = {
          element: element,
          keyframes: keyframes$$1,
          props: props
        };

        Animate._animationObjects.push(obj);

        Animate._parseProperties(obj);

        Animate._createAnimation(obj);

        Animate._setCallback(obj);
      };

      Animate.scrollTo = function (element, props) {
        var obj = {
          element: element,
          props: props,
          step: 0
        };

        Animate._setScrollProperties(obj);

        if (obj.props.delay) {
          setTimeout(Animate._animationObjects, obj.props.delay * 1000, obj);
        } else {
          Animate._animateScroll(obj);
        }

        Animate._animationObjects.push(obj);
      };

      Animate._setScrollProperties = function (obj) {
        obj.beginTop = obj.element.scrollTop;
        obj.change = obj.props.top - obj.beginTop;
        obj.props.duration = obj.props.duration * 1000;
      };

      Animate._parseProperties = function (obj) {
        var nonTweenProps = Animate._timeProps.concat(Animate._callbackProps);

        obj.tweenObj = {};

        for (var key in obj.props) {
          if (Animate._contains(nonTweenProps, key)) {
            obj[key] = obj.props[key];
          } else {
            obj.tweenObj[key] = obj.props[key];
          }
        }
      };

      Animate._animateScroll = function (obj) {
        var totalSteps = obj.props.duration / SCROLL_FRAME_RATE;

        var top = Animate._easeOutExpo(obj.step++, obj.beginTop, obj.change, totalSteps);

        obj.element.scrollTop = top;

        if (obj.step >= totalSteps) {
          obj.element.scrollTop = obj.props.top;

          Animate._executeCallback(obj.props);

          Animate._removeAnimationObject(obj);
        } else {
          setTimeout(function () {
            requestAnimationFrame(function () {
              Animate._animateScroll(obj);
            });
          }, SCROLL_FRAME_RATE);
        }
      };

      Animate._createTransition = function (obj) {
        var duration = obj.duration || 0;
        var delay = obj.delay || 0;
        obj.element.style.transitionProperty = Animate._getTransitionProperties(obj.tweenObj);
        obj.element.style.transitionDuration = duration.toString() + "s";
        obj.element.style.transitionTimingFunction = obj.ease || "linear";
        obj.element.style.transitionDelay = delay.toString() + "s";
      };

      Animate._createAnimation = function (obj) {
        var duration = obj.duration || 0;
        var delay = obj.delay || 0;
        obj.element.style.animationName = obj.keyframes;
        obj.element.style.animationDuration = duration.toString() + "s";
        obj.element.style.animationTimingFunction = obj.ease || "linear";
        obj.element.style.animationDelay = delay.toString() + "s";
        obj.element.style.animationFillMode = "both";
      };

      Animate._getTransitionProperties = function (obj) {
        var hasTransform = false;
        var hasFilter = false;
        var properties = [];

        for (var key in obj) {
          if (Animate._contains(Animate._transformProps, key)) {
            hasTransform = true;
          } else if (Animate._contains(Animate._filters, key)) {
            hasFilter = true;
          } else {
            properties.push(Animate._camelCaseToDash(key));
          }
        }

        if (hasTransform) {
          properties.push("transform");
        }

        if (hasFilter) {
          properties.push("-webkit-filter");
          properties.push("filter");
        }

        return properties.join(", ");
      };

      Animate._setProperties = function (obj) {
        for (var key in obj.tweenObj) {
          if (Animate._contains(Animate._transformProps, key)) {
            Animate._setTransformValues(obj, key);
          } else if (Animate._contains(Animate._filters, key)) {
            Animate._setFilterValues(obj, key);
          } else {
            Animate._setRegularValues(obj, key);
          }
        }

        if (obj.transformations) {
          Animate._setTransformations(obj);
        }
      };

      Animate._setRegularValues = function (obj, key) {
        var value = obj.tweenObj[key];

        if (value.toString().indexOf("%") === -1) {
          value += key !== "opacity" && key !== "backgroundColor" && key !== "boxShadow" ? "px" : "";
        }

        obj.element.style[key] = value;
      };

      Animate._setFilterValues = function (obj, key) {
        var value = obj.tweenObj[key];

        if (key === "hueRotate") {
          value = "(" + value + "deg)";
        } else {
          value = key === "blur" ? "(" + value + "px)" : "(" + value + "%)";
        }

        key = Animate._camelCaseToDash(key);
        obj.element.style.webkitFilter = key + value;
        obj.element.style.filter = key + value;
      };

      Animate._setTransformValues = function (obj, key) {
        if (/x|y|z|scaleX|scaleY|scaleZ|rotate|rotateX|rotateY|rotateZ|skewX|skewY/.test(key)) {
          obj.transformations[key] = obj.tweenObj[key];
        }
      };

      Animate._setTransformations = function (obj) {
        var rotate = "",
            scale = "",
            skew = "",
            translate = "";
        var trans = obj.transformations;
        translate += trans.x !== undefined && trans.x ? "translateX(" + trans.x + "px) " : "";
        translate += trans.y !== undefined && trans.y ? "translateY(" + trans.y + "px) " : "";
        translate += trans.z !== undefined && trans.z ? "translateZ(" + trans.z + "px) " : "";
        rotate += trans.rotate !== undefined && trans.rotate ? "rotate(" + trans.rotate + "deg) " : "";
        rotate += trans.rotateX !== undefined && trans.rotateX ? "rotateX(" + trans.rotateX + "deg) " : "";
        rotate += trans.rotateY !== undefined && trans.rotateY ? "rotate(" + trans.rotateY + "deg) " : "";
        rotate += trans.rotateZ !== undefined && trans.rotateZ ? "rotate(" + trans.rotateZ + "deg) " : "";
        scale += trans.scaleX !== undefined && trans.scaleX ? "scaleX(" + trans.scaleX + ") " : "";
        scale += trans.scaleY !== undefined && trans.scaleY ? "scaleY(" + trans.scaleY + ") " : "";
        scale += trans.scaleZ !== undefined && trans.scaleZ ? "scaleZ(" + trans.scaleZ + ") " : "";
        skew += trans.skewX !== undefined && trans.skewX ? "skewX(" + trans.skewX + "deg) " : "";
        skew += trans.skewY !== undefined && trans.skewY ? "skewY(" + trans.skewY + "deg) " : "";
        obj.element.style.transform = translate + rotate + scale + skew;
      };

      Animate._setCallback = function (obj) {
        obj.element.addEventListener("webkitTransitionEnd", Animate._complete, false);
        obj.element.addEventListener("transitionend", Animate._complete, false);
        obj.element.addEventListener("webkitAnimationEnd", Animate._complete, false);
        obj.element.addEventListener("animationend", Animate._complete, false);
      };

      Animate._complete = function (event) {
        event.target.removeEventListener("webkitTransitionEnd", Animate._complete);
        event.target.removeEventListener("transitionend", Animate._complete);
        event.target.removeEventListener("webkitAnimationEnd", Animate._complete);
        event.target.removeEventListener("animationend", Animate._complete);

        var obj = Animate._getAnimationObjByElement(event.target);

        Animate._executeCallback(obj);

        Animate._removeAnimationObject(obj);
      };

      Animate._getAnimationObjByElement = function (element) {
        var i = Animate._animationObjects.length;

        while (i--) {
          if (Animate._animationObjects[i].element === element) {
            return Animate._animationObjects[i];
          }
        }

        return null;
      };

      Animate._removeAnimationObject = function (obj) {
        var i = Animate._animationObjects.length;

        while (i--) {
          if (Animate._animationObjects[i] === obj) {
            Animate._animationObjects.splice(i, 1);
          }
        }
      };

      Animate._executeCallback = function (obj) {
        if (obj.onEnd) {
          var endArgs = obj.onEndArgs || [];
          obj.onEnd.apply(null, endArgs);
        }
      };

      Animate._contains = function (array, value) {
        var i = array.length;

        while (i--) {
          if (value === array[i]) {
            return true;
          }
        }

        return false;
      };

      Animate._camelCaseToDash = function (value) {
        return value.replace(/\W+/g, "-").replace(/([a-z\d])([A-Z])/g, "$1-$2").toLowerCase();
      };

      Animate._easeOutExpo = function (time, begin, change, duration) {
        return time === duration ? begin + change : change * (-Math.pow(2, -10 * time / duration) + 1) + begin;
      };

      Animate._transformProps = ["x", "y", "z", "scaleX", "scaleY", "scaleZ", "rotate", "rotateX", "rotateY", "rotateZ", "skewX", "skewY"];
      Animate._filters = ["blur", "brightness", "contrast", "dropShadow", "grayscale", "hueRotate", "invert", "saturate", "sepia"];
      Animate._timeProps = ["duration", "ease", "delay"];
      Animate._callbackProps = ["onEnd", "onEndArgs"];
      Animate._animationObjects = [];
      return Animate;
    }();

    var Ease = function () {
      function Ease() {}

      Ease.CB = "cubic-bezier";
      Ease.QUAD_EASE_IN = Ease.CB + "(0.550, 0.085, 0.680, 0.530)";
      Ease.CUBIC_EASE_IN = Ease.CB + "(0.550, 0.055, 0.675, 0.190)";
      Ease.QUART_EASE_IN = Ease.CB + "(0.895, 0.030, 0.685, 0.220)";
      Ease.QUINT_EASE_IN = Ease.CB + "(0.755, 0.050, 0.855, 0.060)";
      Ease.SINE_EASE_IN = Ease.CB + "(0.470, 0, 0.745, 0.715)";
      Ease.EXPO_EASE_IN = Ease.CB + "(0.950, 0.050, 0.795, 0.035)";
      Ease.CIRC_EASE_IN = Ease.CB + "(0.600, 0.040, 0.980, 0.335)";
      Ease.BACK_EASE_IN = Ease.CB + "(0.600, 0.040, 0.980, 0.335)";
      Ease.QUAD_EASE_OUT = Ease.CB + "(0.250, 0.460, 0.450, 0.940)";
      Ease.CUBIC_EASE_OUT = Ease.CB + "(0.215, 0.610, 0.355, 1)";
      Ease.QUART_EASE_OUT = Ease.CB + "(0.165, 0.840, 0.440, 1)";
      Ease.QUINT_EASE_OUT = Ease.CB + "(0.230, 1, 0.320, 1)";
      Ease.SINE_EASE_OUT = Ease.CB + "(0.390, 0.575, 0.565, 1)";
      Ease.EXPO_EASE_OUT = Ease.CB + "(0.190, 1, 0.220, 1)";
      Ease.CIRC_EASE_OUT = Ease.CB + "(0.075, 0.820, 0.165, 1)";
      Ease.BACK_EASE_OUT = Ease.CB + "(0.175, 0.885, 0.320, 1.275)";
      Ease.QUAD_EASE_IN_OUT = Ease.CB + "(0.455, 0.030, 0.515, 0.955)";
      Ease.CUBIC_EASE_IN_OUT = Ease.CB + "(0.645, 0.045, 0.355, 1)";
      Ease.QUART_EASE_IN_OUT = Ease.CB + "(0.770, 0, 0.175, 1)";
      Ease.QUINT_EASE_IN_OUT = Ease.CB + "(0.860, 0, 0.070, 1)";
      Ease.SINE_EASE_IN_OUT = Ease.CB + "(0.445, 0.050, 0.550, 0.950)";
      Ease.EXPO_EASE_IN_OUT = Ease.CB + "(1, 0, 0, 1)";
      Ease.CIRC_EASE_IN_OUT = Ease.CB + "(0.785, 0.135, 0.150, 0.860)";
      Ease.BACK_EASE_IN_OUT = Ease.CB + "(0.680, -0.550, 0.265, 1.550)";
      return Ease;
    }();

    var PersonaCard = function () {
      function PersonaCard(container) {
        this._container = container;

        var activeElement = this._container.querySelector(".ms-PersonaCard-action.is-active");

        var activeId = activeElement.getAttribute("data-action-id");
        this._actions = this._container.querySelector(".ms-PersonaCard-actions");
        this._expander = this._container.querySelector(".ms-PersonaCard-detailExpander");
        this._actionDetailBox = this._container.querySelector(".ms-PersonaCard-actionDetailBox");

        this._setDetail(activeId);

        this._boundOnActionClick = this._onActionClick.bind(this);
        this._boundOnExpanderClick = this._onExpanderClick.bind(this);
        this._boundOnTab = this._onTab.bind(this);

        this._addListeners();
      }

      PersonaCard.prototype.removeListeners = function () {
        this._actions.removeEventListener("click", this._boundOnActionClick);

        this._expander.removeEventListener("click", this._boundOnExpanderClick);

        this._container.removeEventListener("keydown", this._boundOnTab);
      };

      PersonaCard.prototype._addListeners = function () {
        this._actions.addEventListener("click", this._boundOnActionClick, false);

        this._expander.addEventListener("click", this._boundOnExpanderClick, false);

        this._container.addEventListener("keydown", this._boundOnTab, false);
      };

      PersonaCard.prototype._onTab = function (event) {
        var target = event.target;

        if (event.keyCode === 9 && target.classList.contains("ms-PersonaCard-action")) {
          this._onActionClick(event);
        }
      };

      PersonaCard.prototype._onExpanderClick = function (event) {
        var parent = event.target.parentElement;

        if (parent.classList.contains("is-collapsed")) {
          parent.classList.remove("is-collapsed");
        } else {
          parent.classList.add("is-collapsed");
        }

        var parentHeight = parent.clientHeight;

        this._animateDetail(parentHeight);
      };

      PersonaCard.prototype._onActionClick = function (event) {
        var target = event.target;
        var actionId = target.getAttribute("data-action-id");

        if (actionId && target.className.indexOf("is-active") === -1) {
          this._setAction(target);

          this._setDetail(actionId);
        }
      };

      PersonaCard.prototype._setAction = function (target) {
        var activeElement = this._container.querySelector(".ms-PersonaCard-action.is-active");

        activeElement.classList.remove("is-active");
        target.classList.add("is-active");
      };

      PersonaCard.prototype._setDetail = function (activeId) {
        var selector = ".ms-PersonaCard-details[data-detail-id='" + activeId + "']";

        var lastDetail = this._container.querySelector(".ms-PersonaCard-details.is-active");

        var activeDetail = this._container.querySelector(selector);

        if (lastDetail) {
          lastDetail.classList.remove("is-active");
        }

        activeDetail.classList.add("is-active");
        var detailHeight = activeDetail.clientHeight;

        this._animateDetail(detailHeight);
      };

      PersonaCard.prototype._animateDetail = function (height) {
        var _this = this;

        this._actionDetailBox.style.overflowY = "hidden";
        Animate.transition(this._actionDetailBox, {
          height: height,
          duration: 0.25,
          ease: Ease.SINE_EASE_OUT,
          onEnd: function onEnd() {
            _this._actionDetailBox.style.overflowY = "auto";
          }
        });
      };

      return PersonaCard;
    }();

    var MODAL_POSITION$3 = "top";

    var Persona = function () {
      function Persona(container) {
        this._persona = container;
        this._personaCard = this._persona.querySelector(".ms-PersonaCard");

        if (this._personaCard) {
          this._assignEvents();

          this._personaCard.setAttribute("style", "display: none;");

          this._createPersonaCard();
        }
      }

      Persona.prototype._createPersonaCard = function () {
        this._personaCardInstance = new PersonaCard(this._personaCard);
      };

      Persona.prototype._createContextualHostInstance = function () {
        this._personaCard.setAttribute("style", "display: block;");

        this._contextualHostInstance = new ContextualHost(this._personaCard, MODAL_POSITION$3, this._persona);
      };

      Persona.prototype._personaEventHandler = function () {
        this._createContextualHostInstance();
      };

      Persona.prototype._assignEvents = function () {
        var _this = this;

        this._persona.addEventListener("click", this._personaEventHandler.bind(this), false);

        this._persona.addEventListener("keyup", function (e) {
          return e.keyCode === 32 ? _this._personaEventHandler() : null;
        }, false);
      };

      return Persona;
    }();

    var pivot = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"pivot",staticClass:"ms-Pivot",class:_vm.pivotClass},[_c('ul',{staticClass:"ms-Pivot-links",on:{"click":_vm.clickEvent}},_vm._l((_vm.pivotItems),function(item,index){return _c('li',{staticClass:"ms-Pivot-link",class:{ 'is-selected': index == 0 },attrs:{"tabindex":"1","data-content":item,"title":item}},[_vm._v(" "+_vm._s(item)+" ")])})),_vm._v(" "),_vm._t("default")],2)},staticRenderFns: [],
      name: 'ou-pivot',

      mixins: [
        size('large'),
        type('tabs'),
        eventHub
      ],

      data: function data() {
        return {
          pivotItems: []
        };
      },

      computed: {
        pivotClass: function pivotClass() {
          var obj;

          return ( obj = {}, obj[("ms-Pivot--" + (this.size))] = !!this.size, obj[("ms-Pivot--" + (this.type))] = !!this.type, obj );
        }
      },

      created: function created() {
        this.eventHub.$on('addPivotItem', this.addPivotItem);
      },

      beforeDestroy: function beforeDestroy() {
        this.eventHub.$off('addPivotItem', this.addPivotItem);
      },

      mounted: function mounted() {
        new this.$fabric.Pivot(this.$refs.pivot);
      },

      methods: {
        addPivotItem: function addPivotItem(label) {
          this.pivotItems.push(label);
        },

        clickEvent: function clickEvent(event) {
          if (event.target.tagName == 'LI') {
            this.$emit('click', event);
          }
        }
      }
    };

    var Pivot = function () {
      function Pivot(container) {
        this._container = container;

        this._addListeners();

        var firstContent = this._container.querySelector(".ms-Pivot-content");

        firstContent.style.display = "block";
      }

      Pivot.prototype.removeListeners = function () {
        this._container.removeEventListener("click", this._selectTab.bind(this));
      };

      Pivot.prototype._addListeners = function () {
        var _this = this;

        this._container.querySelector(".ms-Pivot-links").addEventListener("click", this._selectTabMouse.bind(this), false);

        this._container.addEventListener("keyup", function (event) {
          if (event.keyCode === 13) {
            _this._selectTabKeyboard(event);
          }
        }, true);
      };

      Pivot.prototype._selectTab = function (selectedTab) {
        if (selectedTab.classList.contains("ms-Pivot-link") && !selectedTab.querySelector(".ms-Pivot-ellipsis")) {
          var sibling = selectedTab.parentElement.firstElementChild;

          while (sibling) {
            sibling.classList.remove("is-selected");
            sibling = sibling.nextElementSibling;
          }

          selectedTab.classList.add("is-selected");

          var containers = this._container.querySelectorAll(".ms-Pivot-content");

          Array.prototype.forEach.call(containers, function (el, i) {
            el.style.display = "none";
          });
          var selectedContentName = selectedTab.getAttribute("data-content");

          var selectedContent = this._container.querySelector(".ms-Pivot-content[data-content='" + selectedContentName + "']");

          selectedContent.style.display = "block";
        }
      };

      Pivot.prototype._selectTabMouse = function (event) {
        event.preventDefault();
        var selectedTab = event.target;

        this._selectTab(selectedTab);
      };

      Pivot.prototype._selectTabKeyboard = function (event) {
        event.preventDefault();
        var selectedTab = event.target;

        this._selectTab(selectedTab);
      };

      return Pivot;
    }();

    var ProgressIndicator$1 = function () {
      function ProgressIndicator(container) {
        this.container = container;
        this.cacheDOM();
      }

      ProgressIndicator.prototype.setProgressPercent = function (percent) {
        this._progressBar.style.width = Math.round(this._width * percent) + "px";
      };

      ProgressIndicator.prototype.setProgress = function (progress) {
        this._progress = progress;
        var percentage = this._progress / this._total;
        this.setProgressPercent(percentage);
      };

      ProgressIndicator.prototype.setTotal = function (total) {
        this._total = total;
      };

      ProgressIndicator.prototype.setName = function (name) {
        this._itemName.innerHTML = name;
      };

      ProgressIndicator.prototype.setDescription = function (description) {
        this._itemDescription.innerHTML = description;
      };

      ProgressIndicator.prototype.cacheDOM = function () {
        this._itemName = this.container.querySelector(".ms-ProgressIndicator-itemName") || null;
        this._itemDescription = this.container.querySelector(".ms-ProgressIndicator-itemDescription") || null;
        this._progressBar = this.container.querySelector(".ms-ProgressIndicator-progressBar");
        var itemProgress = this.container.querySelector(".ms-ProgressIndicator-itemProgress");
        this._width = itemProgress.offsetWidth;
      };

      return ProgressIndicator;
    }();

    var searchBox = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"searchBox",staticClass:"ms-SearchBox",class:_vm.searchBoxClass},[_c('input',{ref:"searchBoxInput",staticClass:"ms-SearchBox-field",attrs:{"type":"text"},domProps:{"value":_vm.value},on:{"input":_vm.updateValue}}),_vm._v(" "),_c('label',{staticClass:"ms-SearchBox-label"},[_c('i',{staticClass:"ms-SearchBox-icon ms-Icon ms-Icon--Search"}),_vm._v(" "),(!_vm.hasValue)?_c('span',{staticClass:"ms-SearchBox-text"},[_vm._v(_vm._s(_vm.placeholder))]):_vm._e()]),_vm._v(" "),_c('div',{staticClass:"ms-CommandButton ms-SearchBox-clear ms-CommandButton--noLabel",on:{"mousedown":_vm.clearValue}},[_vm._m(0)])])},staticRenderFns: [function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('button',{staticClass:"ms-CommandButton-button"},[_c('span',{staticClass:"ms-CommandButton-icon"},[_c('i',{staticClass:"ms-Icon ms-Icon--Clear"})]),_vm._v(" "),_c('span',{staticClass:"ms-CommandButton-label"})])}],
      name: 'ou-search-box',

      mixins: [type('commandBar')],

      props: {
        value: String,
        placeholder: String,

        collapsed: {
          type: Boolean,
          default: false
        }
      },

      data: function data() {
        return {
          hasValue: !!this.value,
          searchBoxInstance: null
        };
      },

      computed: {
        searchBoxClass: function searchBoxClass() {
          var obj;

          return ( obj = {}, obj[("ms-SearchBox--" + (this.type))] = !!this.type, obj['is-collapsed'] =  this.collapsed, obj );
        }
      },

      mounted: function mounted() {
        this.searchBoxInstance = new this.$fabric.SearchBox(this.$refs.searchBox);

        // Overwrite the default blur event on searchBoxField
        // to prevent lose content when searchBox blur.
        // You can see here https://github.com/OfficeDev/office-ui-fabric-js/issues/301
        this.searchBoxInstance._searchBoxField.removeEventListener('blur', this.searchBoxInstance._boundHandleBlur, true);
        this.searchBoxInstance._searchBoxField.addEventListener('blur', this.blurEvent, true);
      },

      methods: {
        updateValue: function updateValue(event) {
          this.$emit('input', event.target.value);
        },

        clearValue: function clearValue() {
          this.$emit('input', '');
        },

        blurEvent: function blurEvent() {
          var self = this.searchBoxInstance;

          if (!self._clearOnly) {
            self._searchBox.removeEventListener('keyup', self._boundEnableClose);
            setTimeout(function () {
              if (!self._searchBox.contains(document.activeElement) && self._searchBoxField.value == '') {
                self._clearSearchBox();
                self._collapseSearchBox();
                self.setCollapsedListeners();
              }
            }, 10);
          } else {
            self._searchBoxField.focus();
          }

          self._clearOnly = false;
        }
      }
    };

    var uiSearchbox = {_scopeId: 'data-v-880410a2',
        beforeCreate: function beforeCreate(){ loadThemedStyles.loadStyles("/* Your use of the content in the files referenced here are subject to the terms of the license at http://aka.ms/fabric-font-license */ /* Theme related color values */ /* Natural Colors */ /* Base Colors */ /** Black #000 **/ /** Blue #0078d7 **/ /** Green #107c10 **/ /** Green #b4009e **/ /** Orange #d83b01 **/ /** Purble #5c2d91 **/ /** Red #e81123 **/ /*** Teal ***/ /** White **/ /** Yellow **/ /* State Colors */ /** Alerts **/ /** Error **/ /** Info ***/ /** Warning **/ /** Server Warning **/ /** Success **/ /* Get css for state objects for: alert, error, info, servere, success This includes color and background styles */ /* Get css for state objects for: alert, error, info, servere, success This includes only the color values */ /*** 100 Thin (Hairline) 200 Extra Light (Ultra Light) 300 Light 400 Normal 500 Medium 600 Semi Bold (Demi Bold) 700 Bold 800 Extra Bold (Ultra Bold) 900 Black (Heavy) **/ /* Natural Colors */ /* Base Colors */ /** Black #000 **/ /** Blue #0078d7 **/ /** Green #107c10 **/ /** Green #b4009e **/ /** Orange #d83b01 **/ /** Purble #5c2d91 **/ /** Red #e81123 **/ /*** Teal ***/ /** White **/ /** Yellow **/ /* State Colors */ /** Alerts **/ /** Error **/ /** Info ***/ /** Warning **/ /** Server Warning **/ /** Success **/ .ms-Label[data-v-880410a2] { font-family: \"Segoe UI WestEuropean\", \"Segoe UI\", -apple-system, BlinkMacSystemFont, \"Roboto\", \"Helvetica Neue\", sans-serif; -webkit-font-smoothing: antialiased; box-sizing: border-box; margin: 0; padding: 0; -webkit-box-shadow: none; -moz-box-shadow: none; box-shadow: none; color: \"[theme:neutralPrimary, default: #333333]\"; font-size: 12px; font-weight: 400; box-sizing: border-box; display: block; padding: 5px 0; } .ms-Label.is-required[data-v-880410a2]::after { content: ' *'; color: \"[theme:error, default: #a80000]\"; } .ms-Label.is-disabled[data-v-880410a2] { color: \"[theme:neutralTertiary, default: #a6a6a6]\"; } /* searchbox uses mixins from label */ .ms-CommandButton[data-v-880410a2] { font-family: \"Segoe UI WestEuropean\", \"Segoe UI\", -apple-system, BlinkMacSystemFont, \"Roboto\", \"Helvetica Neue\", sans-serif; -webkit-font-smoothing: antialiased; display: inline-block; position: relative; vertical-align: top; } .ms-CommandButton.is-hidden[data-v-880410a2] { display: none; } .ms-CommandButton:disabled .ms-CommandButton-button[data-v-880410a2], .ms-CommandButton.is-disabled .ms-CommandButton-button[data-v-880410a2] { cursor: default; } .ms-CommandButton:disabled .ms-CommandButton-button[data-v-880410a2]:hover, .ms-CommandButton.is-disabled .ms-CommandButton-button[data-v-880410a2]:hover { background-color: \"[theme:themeLighterAlt, default: #eff6fc]\"; } .ms-CommandButton:disabled .ms-CommandButton-button .ms-CommandButton-label[data-v-880410a2], .ms-CommandButton.is-disabled .ms-CommandButton-button .ms-CommandButton-label[data-v-880410a2] { color: \"[theme:neutralTertiary, default: #a6a6a6]\"; } .ms-CommandButton:disabled .ms-CommandButton-button .ms-CommandButton-icon[data-v-880410a2], .ms-CommandButton.is-disabled .ms-CommandButton-button .ms-CommandButton-icon[data-v-880410a2] { color: \"[theme:neutralTertiary, default: #a6a6a6]\"; } .ms-CommandButton .ms-ContextualMenu[data-v-880410a2] { display: none; } .ms-CommandButton-button[data-v-880410a2], .ms-CommandButton-splitIcon[data-v-880410a2] { box-sizing: border-box; margin: 0; padding: 0; -webkit-box-shadow: none; -moz-box-shadow: none; box-shadow: none; color: \"[theme:neutralPrimary, default: #333333]\"; font-size: 14px; font-weight: 400; cursor: pointer; display: inline-block; height: 40px; line-height: 40px; outline: 1px solid transparent; padding: 0 8px; position: relative; vertical-align: top; background: transparent; } .ms-CommandButton-button[data-v-880410a2]:hover, .ms-CommandButton-splitIcon[data-v-880410a2]:hover { background-color: \"[theme:neutralLight, default: #eaeaea]\"; } .ms-CommandButton-button:hover .ms-CommandButton-label[data-v-880410a2], .ms-CommandButton-splitIcon:hover .ms-CommandButton-label[data-v-880410a2] { color: \"[theme:neutralDark, default: #212121]\"; } .ms-CommandButton-button[data-v-880410a2]:active, .ms-CommandButton-splitIcon[data-v-880410a2]:active { background-color: \"[theme:neutralLight, default: #eaeaea]\"; } .ms-CommandButton-button[data-v-880410a2]:focus::before, .ms-CommandButton-splitIcon[data-v-880410a2]:focus::before { top: 3px; left: 3px; right: 3px; bottom: 3px; border: 1px solid \"[theme:neutralPrimary, default: #333333]\"; position: absolute; z-index: 10; content: ''; outline: none; } .ms-CommandButton-button[data-v-880410a2]:focus, .ms-CommandButton-splitIcon[data-v-880410a2]:focus { outline: 0; } @media only screen and (max-width: 639px) { .ms-CommandButton-button[data-v-880410a2], .ms-CommandButton-splitIcon[data-v-880410a2] { height: 44px; } .ms-CommandButton-button .ms-CommandButton-icon[data-v-880410a2], .ms-CommandButton-splitIcon .ms-CommandButton-icon[data-v-880410a2] { font-size: 20px; } .ms-CommandButton-button .ms-CommandButton-label[data-v-880410a2], .ms-CommandButton-splitIcon .ms-CommandButton-label[data-v-880410a2] { line-height: 44px; } } .ms-CommandButton-button[data-v-880410a2] { border: 0; margin: 0; } .ms-CommandButton + .ms-CommandButton[data-v-880410a2] { margin-left: 8px; } @media only screen and (max-width: 639px) { .ms-CommandButton + .ms-CommandButton[data-v-880410a2] { margin-left: 4px; } } .ms-CommandButton-icon[data-v-880410a2] { display: inline-block; margin-right: 8px; position: relative; font-size: 16px; min-width: 16px; height: 100%; } .ms-CommandButton-icon .ms-Icon[data-v-880410a2] { position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); } .ms-CommandButton-label[data-v-880410a2] { font-size: 14px; font-weight: 400; color: \"[theme:neutralPrimary, default: #333333]\"; line-height: 40px; height: 100%; display: inline-block; vertical-align: top; } .ms-CommandButton-label[data-v-880410a2]:hover { color: \"[theme:neutralDark, default: #212121]\"; } .ms-CommandButton-dropdownIcon[data-v-880410a2], .ms-CommandButton-splitIcon[data-v-880410a2] { display: inline-block; position: relative; color: \"[theme:neutralPrimary, default: #333333]\"; font-size: 12px; font-weight: 300; min-width: 12px; height: 100%; vertical-align: top; margin-left: 8px; } .ms-CommandButton-dropdownIcon .ms-Icon[data-v-880410a2], .ms-CommandButton-splitIcon .ms-Icon[data-v-880410a2] { line-height: normal; padding-top: 16px; } .ms-CommandButton-dropdownIcon[data-v-880410a2]:focus::before, .ms-CommandButton-splitIcon[data-v-880410a2]:focus::before { top: 3px; left: 3px; right: 3px; bottom: 3px; border: 1px solid \"[theme:neutralPrimary, default: #333333]\"; position: absolute; z-index: 10; content: ''; outline: none; } @media only screen and (max-width: 639px) { .ms-CommandButton-dropdownIcon[data-v-880410a2], .ms-CommandButton-splitIcon[data-v-880410a2] { display: none; } } .ms-CommandButton-splitIcon[data-v-880410a2] { margin-left: -2px; width: 27px; border: 0; } .ms-CommandButton-splitIcon .ms-Icon[data-v-880410a2] { margin-left: -1px; position: relative; padding-top: 16px; } .ms-CommandButton-splitIcon .ms-Icon[data-v-880410a2]::after { position: absolute; content: ' '; width: 1px; height: 16px; top: 12px; left: -8px; border-left: 1px solid \"[theme:neutralTertiaryAlt, default: #c8c8c8]\"; } .ms-CommandButton.ms-CommandButton--noLabel .ms-CommandButton-icon[data-v-880410a2] { margin-right: 0; } .ms-CommandButton.ms-CommandButton--noLabel .ms-CommandButton-label[data-v-880410a2] { display: none; } .ms-CommandButton.ms-CommandButton--noLabel .ms-CommandButton-button[data-v-880410a2] { padding: 0 12px; } .ms-CommandButton.ms-CommandButton--inline .ms-CommandButton-button[data-v-880410a2] { background: none; } .ms-CommandButton.ms-CommandButton--actionButton .ms-CommandButton-button[data-v-880410a2] { width: 50px; height: 40px; } .ms-CommandButton.ms-CommandButton--actionButton .ms-CommandButton-icon[data-v-880410a2] { position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 16px; height: 16px; padding-right: 0; } .ms-CommandButton.ms-CommandButton--pivot.is-active[data-v-880410a2]::before { content: ''; height: 2px; position: absolute; left: 0; right: 0; background-color: \"[theme:themePrimary, default: #0078d7]\"; bottom: 0; z-index: 5; } .ms-CommandButton.ms-CommandButton--pivot[data-v-880410a2]:hover::before { content: ''; height: 2px; position: absolute; left: 0; right: 0; background-color: \"[theme:themePrimary, default: #0078d7]\"; bottom: 0; z-index: 5; } .ms-CommandButton.ms-CommandButton--textOnly .ms-CommandButton-label[data-v-880410a2], .ms-CommandButton.ms-CommandButton--pivot .ms-CommandButton-label[data-v-880410a2] { display: inline-block; } @media only screen and (max-width: 479px) { .ms-CommandButton.ms-CommandButton--textOnly .ms-CommandButton-label[data-v-880410a2], .ms-CommandButton.ms-CommandButton--pivot .ms-CommandButton-label[data-v-880410a2] { font-size: 16px; } } /* searchbox uses classes from CommandButton */ .ms-SearchBox[data-v-880410a2] { font-family: \"Segoe UI WestEuropean\", \"Segoe UI\", -apple-system, BlinkMacSystemFont, \"Roboto\", \"Helvetica Neue\", sans-serif; -webkit-font-smoothing: antialiased; box-sizing: border-box; margin: 0; padding: 0; -webkit-box-shadow: none; -moz-box-shadow: none; box-shadow: none; height: 36px; color: \"[theme:neutralPrimary, default: #333333]\"; font-size: 14px; font-weight: 400; position: relative; margin-bottom: 10px; display: inline-block; overflow: hidden; background-color: \"[theme:white, default: #ffffff]\"; } .ms-SearchBox.is-active[data-v-880410a2] { z-index: 10; } .ms-SearchBox.is-active .ms-SearchBox-label[data-v-880410a2] { display: none; } .ms-SearchBox.is-active .ms-SearchBox-clear[data-v-880410a2] { display: block; } .ms-SearchBox[data-v-880410a2]:hover { background-color: \"[theme:themeLighter, default: #deecf9]\"; } .ms-SearchBox:hover .ms-SearchBox-label[data-v-880410a2] { color: \"[theme:black, default: #000000]\"; } .ms-SearchBox:hover .ms-SearchBox-label .ms-Icon[data-v-880410a2] { color: \"[theme:neutralPrimary, default: #333333]\"; } .ms-SearchBox.is-disabled[data-v-880410a2] { background-color: #F4F4F4; pointer-events: none; } .ms-SearchBox.is-disabled .ms-SearchBox-label[data-v-880410a2] { color: \"[theme:neutralTertiary, default: #a6a6a6]\"; } .ms-SearchBox.is-disabled .ms-SearchBox-icon[data-v-880410a2] { color: \"[theme:neutralTertiary, default: #a6a6a6]\"; } .ms-SearchBox.is-disabled .ms-SearchBox-field[data-v-880410a2] { color: \"[theme:neutralTertiary, default: #a6a6a6]\"; background-color: transparent; border-color: \"[theme:neutralLighter, default: #f4f4f4]\"; cursor: default; } .ms-SearchBox-clear[data-v-880410a2] { display: none; position: absolute; top: 0; right: 0; z-index: 10; } .ms-SearchBox-clear .ms-CommandButton-button[data-v-880410a2] { background-color: \"[theme:themePrimary, default: #0078d7]\"; color: \"[theme:white, default: #ffffff]\"; height: 36px; } .ms-SearchBox-clear .ms-CommandButton-icon[data-v-880410a2] { color: \"[theme:white, default: #ffffff]\"; } .ms-SearchBox-icon[data-v-880410a2] { position: relative; top: 50%; transform: translateY(-50%); display: inline-block; font-size: 16px; width: 16px; margin-left: 12px; margin-right: 6px; color: \"[theme:themePrimary, default: #0078d7]\"; vertical-align: top; } .ms-SearchBox-field[data-v-880410a2] { position: relative; box-sizing: border-box; margin: 0; padding: 0; -webkit-box-shadow: none; -moz-box-shadow: none; box-shadow: none; border: 1px solid \"[theme:themeTertiary, default: #71afe5]\"; outline: transparent 1px solid; font-weight: 300; font-size: 14px; color: \"[theme:black, default: #000000]\"; height: 36px; padding: 6px 3px 7px 45px; width: 208px; background-color: transparent; z-index: 5; transition: padding-left 0.167s; } .ms-SearchBox-field[data-v-880410a2]:focus { padding: 6px 32px 7px 10px; border-color: \"[theme:themePrimary, default: #0078d7]\"; background-color: \"[theme:themeLighter, default: #deecf9]\"; } .ms-SearchBox-field[data-v-880410a2]::-ms-clear { display: none; } .ms-SearchBox-label[data-v-880410a2] { position: absolute; top: 0; left: 0; height: 36px; line-height: 36px; color: \"[theme:neutralSecondary, default: #666666]\"; } .ms-SearchBox.ms-SearchBox--commandBar[data-v-880410a2] { background-color: \"[theme:white, default: #ffffff]\"; width: 208px; height: 40px; } .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-field[data-v-880410a2], .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-label[data-v-880410a2] { height: 40px; } .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-field[data-v-880410a2] { transition: none; border: 0; } .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-field[data-v-880410a2]:focus { background-color: transparent; padding: 6px 3px 7px 45px; } .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-clear[data-v-880410a2], .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-filter[data-v-880410a2], .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-exit[data-v-880410a2] { display: none; position: absolute; top: 0; z-index: 10; color: \"[theme:neutralTertiary, default: #a6a6a6]\"; } .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-clear .ms-CommandButton-button[data-v-880410a2], .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-filter .ms-CommandButton-button[data-v-880410a2], .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-exit .ms-CommandButton-button[data-v-880410a2] { height: 40px; background-color: transparent; } .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-clear[data-v-880410a2] { right: 8px; } .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-filter[data-v-880410a2] { right: 8px; } .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-filter .ms-CommandButton-icon[data-v-880410a2] { color: \"[theme:themePrimary, default: #0078d7]\"; } .ms-SearchBox.ms-SearchBox--commandBar[data-v-880410a2]::before { position: absolute; content: ' '; right: 0; bottom: 0; left: 0; margin: 0 8px; border-bottom: 1px solid \"[theme:neutralLight, default: #eaeaea]\"; } .ms-SearchBox.ms-SearchBox--commandBar[data-v-880410a2]:hover { background-color: \"[theme:white, default: #ffffff]\"; } .ms-SearchBox.ms-SearchBox--commandBar:hover .ms-SearchBox-label[data-v-880410a2] { color: \"[theme:neutralDark, default: #212121]\"; } .ms-SearchBox.ms-SearchBox--commandBar:hover .ms-SearchBox-icon[data-v-880410a2] { color: \"[theme:themePrimary, default: #0078d7]\"; } .ms-SearchBox.ms-SearchBox--commandBar[data-v-880410a2]:focus { background-color: transparent; } .ms-SearchBox.ms-SearchBox--commandBar.is-active .ms-CommandButton .ms-SearchBox-exit[data-v-880410a2], .ms-SearchBox.ms-SearchBox--commandBar.is-active .ms-CommandButton .ms-SearchBox-filter[data-v-880410a2] { display: block; } .ms-SearchBox.ms-SearchBox--commandBar.is-collapsed[data-v-880410a2] { width: 50px; min-height: 40px; z-index: 0; background-color: #F4F4F4; } .ms-SearchBox.ms-SearchBox--commandBar.is-collapsed .ms-SearchBox-text[data-v-880410a2] { display: none; } .ms-SearchBox.ms-SearchBox--commandBar.is-collapsed .ms-SearchBox-field[data-v-880410a2] { cursor: pointer; width: calc(100% - 50px); } .ms-SearchBox.ms-SearchBox--commandBar.is-collapsed[data-v-880410a2]::before { visibility: hidden; } .ms-SearchBox.ms-SearchBox--commandBar.is-collapsed.is-active[data-v-880410a2] { width: 100%; } .ms-SearchBox.ms-SearchBox--commandBar.is-collapsed.is-active .ms-SearchBox-field[data-v-880410a2] { display: block; cursor: text; } .ms-SearchBox.ms-SearchBox--commandBar.is-collapsed.is-active .ms-SearchBox-text[data-v-880410a2] { display: inline-block; } @media only screen and (max-width: 639px) { .ms-SearchBox.ms-SearchBox--commandBar.is-collapsed.is-active[data-v-880410a2] { width: 100%; } .ms-SearchBox.ms-SearchBox--commandBar.is-collapsed.is-active .ms-SearchBox-clear[data-v-880410a2] { display: inline-block; right: 58px; } .ms-SearchBox.ms-SearchBox--commandBar.is-collapsed.is-active .ms-SearchBox-filter[data-v-880410a2] { display: inline-block; } .ms-SearchBox.ms-SearchBox--commandBar.is-collapsed.is-active.is-animated[data-v-880410a2] { transition: width 0.167s cubic-bezier(0.1, 0.9, 0.2, 1); } } .ms-SearchBox.ms-SearchBox--commandBar.is-collapsed.is-active[data-v-880410a2]::before { visibility: visible; } .ms-SearchBox.ms-SearchBox--commandBar.has-text .ms-SearchBox-clear[data-v-880410a2] { display: inline-block; } .ms-SearchBox.ms-SearchBox--commandBar.has-text .ms-SearchBox-clear .ms-CommandButton-icon[data-v-880410a2] { color: \"[theme:neutralTertiary, default: #a6a6a6]\"; } .ms-SearchBox.ms-SearchBox--commandBar.has-text .ms-SearchBox-clear .ms-CommandButton-icon[data-v-880410a2]:active { color: \"[theme:themePrimary, default: #0078d7]\"; } @media only screen and (min-width: 1024px) { .ms-SearchBox.ms-SearchBox--commandBar[data-v-880410a2] { background-color: \"[theme:white, default: #ffffff]\"; border-right: 1px solid \"[theme:neutralLight, default: #eaeaea]\"; } } @media only screen and (max-width: 639px) { .ms-SearchBox.ms-SearchBox--commandBar[data-v-880410a2] { height: 44px; } .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-icon[data-v-880410a2], .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-exit[data-v-880410a2], .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-field[data-v-880410a2], .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-label[data-v-880410a2] { height: 44px; line-height: 44px; } .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-icon[data-v-880410a2], .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-exit[data-v-880410a2], .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-filter[data-v-880410a2], .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-clear[data-v-880410a2] { font-size: 20px; } .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-icon .ms-CommandButton-button[data-v-880410a2], .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-exit .ms-CommandButton-button[data-v-880410a2], .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-filter .ms-CommandButton-button[data-v-880410a2], .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-clear .ms-CommandButton-button[data-v-880410a2] { height: 44px; } .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-field[data-v-880410a2], .ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-label[data-v-880410a2] { font-size: 16px; } } .ms-SearchBox.ms-SearchBox--commandBar.is-active[data-v-880410a2] { background-color: \"[theme:white, default: #ffffff]\"; } .ms-SearchBox.ms-SearchBox--commandBar.is-active .ms-SearchBox-label[data-v-880410a2] { display: block; line-height: 40px; height: 40px; } .ms-SearchBox.ms-SearchBox--commandBar.is-active .ms-SearchBox-label .ms-SearchBox-text[data-v-880410a2] { display: none; } .ms-SearchBox.ms-SearchBox--commandBar.is-active[data-v-880410a2]::before { visibility: visible; } @media only screen and (max-width: 639px) { .ms-SearchBox.ms-SearchBox--commandBar.is-active .ms-SearchBox-field[data-v-880410a2] { width: 100%; padding-right: 100px; } .ms-SearchBox.ms-SearchBox--commandBar.is-active .ms-SearchBox-icon[data-v-880410a2] { display: none; } .ms-SearchBox.ms-SearchBox--commandBar.is-active .ms-SearchBox-exit[data-v-880410a2] { display: inline-block; } .ms-SearchBox.ms-SearchBox--commandBar.is-active.has-text .ms-SearchBox-filter .ms-CommandButton-icon[data-v-880410a2] { color: \"[theme:neutralTertiary, default: #a6a6a6]\"; } } .ms-Icon.ms-Icon--Search[data-v-880410a2] { content: url('data:image/svg+xml;utf8,<svg viewBox=\"0 -0 2048 2048\" width=\"16\" height=\"16\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\"><path fill=\"#0078d7\" stroke=\"none\" transform=\"translate(0, 2048) scale(1, -1)\" d=\"M1344 2048q97 0 187 -25t168 -71t142.5 -110.5t110.5 -142.5t71 -168t25 -187t-25 -187t-71 -168t-110.5 -142.5t-142.5 -110.5t-168 -71t-187 -25q-125 0 -239.5 42t-210.5 121l-785 -784q-19 -19 -45 -19t-45 19t-19 45t19 45l784 785q-79 96 -121 210.5t-42 239.5q0 97 25 187t71 168t110.5 142.5t142.5 110.5t168 71t187 25zM1344 768q119 0 224 45.5t183 123.5t123.5 183t45.5 224t-45.5 224t-123.5 183t-183 123.5t-224 45.5t-224 -45.5t-183 -123.5t-123.5 -183t-45.5 -224t45.5 -224t123.5 -183t183 -123.5t224 -45.5z\"/></svg>'); } .ms-Icon.ms-Icon--Clear[data-v-880410a2] { content: url('data:image/svg+xml;utf8,<svg viewBox=\"0 -0 2048 2048\" width=\"14\" height=\"14\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\"><path fill=\"white\" stroke=\"none\" d=\"M1115 1024l914 -915l-90 -90l-915 914l-915 -914l-90 90l914 915l-914 915l90 90l915 -914l915 914l90 -90z\"/></svg>'); } .ms-SearchBox--commandBar .ms-Icon.ms-Icon--Clear[data-v-880410a2] { content: url('data:image/svg+xml;utf8,<svg viewBox=\"0 -0 2048 2048\" width=\"14\" height=\"14\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\"><path fill=\"#a6a6a6\" stroke=\"none\" d=\"M1115 1024l914 -915l-90 -90l-915 914l-915 -914l-90 90l914 915l-914 915l90 90l915 -914l915 914l90 -90z\"/></svg>'); } ");},
        beforeMount: function beforeMount(){
            this.$fabric = {
                SearchBox : SearchBox
            };
        },
        extends :  searchBox
    };

    var Spinner = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"spinner",staticClass:"ms-Spinner",class:_vm.spinnerClass},[(_vm.label)?_c('div',{staticClass:"ms-Spinner-label"},[_vm._v(_vm._s(_vm.label))]):_vm._e()])},staticRenderFns: [],
      name: 'ou-spinner',

      mixins: [type('large')],

      props: {
        label: String
      },

      computed: {
        spinnerClass: function spinnerClass() {
          var obj;

          return ( obj = {}, obj[("ms-Spinner--" + (this.type))] = !!this.type, obj );
        }
      },

      mounted: function mounted() {
        new this.$fabric.Spinner(this.$refs.spinner);
      }
    };

    var CircleObject = function () {
      function CircleObject(element, j) {
        this.element = element;
        this.j = j;
      }

      return CircleObject;
    }();

    var Spinner$1 = function () {
      function Spinner(container) {
        this.eightSize = 0.2;
        this.animationSpeed = 90;
        this.parentSize = 20;
        this.fadeIncrement = 0;
        this.circleObjects = [];
        this._target = container;

        this._init();
      }

      Spinner.prototype.start = function () {
        var _this = this;

        this.stop();
        this.interval = setInterval(function () {
          var i = _this.circleObjects.length;

          while (i--) {
            _this._fade(_this.circleObjects[i]);
          }
        }, this.animationSpeed);
      };

      Spinner.prototype.stop = function () {
        clearInterval(this.interval);
      };

      Spinner.prototype._init = function () {
        this._setTargetElement();

        this._setPropertiesForSize();

        this._createCirclesAndArrange();

        this._initializeOpacities();

        this.start();
      };

      Spinner.prototype._setPropertiesForSize = function () {
        if (this.spinner.className.indexOf("large") > -1) {
          this.parentSize = 28;
          this.eightSize = 0.179;
        }

        this.offsetSize = this.eightSize;
        this.numCircles = 8;
      };

      Spinner.prototype._setTargetElement = function () {
        if (this._target.className.indexOf("ms-Spinner") === -1) {
          this.spinner = document.createElement("div");
          this.spinner.className = "ms-Spinner";

          this._target.appendChild(this.spinner);
        } else {
          this.spinner = this._target;
        }
      };

      Spinner.prototype._initializeOpacities = function () {
        var this$1 = this;

        var i = 0;
        var j = 1;
        var opacity;
        this.fadeIncrement = 1 / this.numCircles;

        for (i; i < this.numCircles; i++) {
          var circleObject = this$1.circleObjects[i];
          opacity = this$1.fadeIncrement * j++;

          this$1._setOpacity(circleObject.element, opacity);
        }
      };

      Spinner.prototype._fade = function (circleObject) {
        var opacity = this._getOpacity(circleObject.element) - this.fadeIncrement;

        if (opacity <= 0) {
          opacity = 1;
        }

        this._setOpacity(circleObject.element, opacity);
      };

      Spinner.prototype._getOpacity = function (element) {
        return parseFloat(window.getComputedStyle(element).getPropertyValue("opacity"));
      };

      Spinner.prototype._setOpacity = function (element, opacity) {
        element.style.opacity = opacity.toString();
      };

      Spinner.prototype._createCircle = function () {
        var circle = document.createElement("div");
        circle.className = "ms-Spinner-circle";
        circle.style.width = circle.style.height = this.parentSize * this.offsetSize + "px";
        return circle;
      };

      Spinner.prototype._createCirclesAndArrange = function () {
        var this$1 = this;

        var angle = 0;
        var offset = this.parentSize * this.offsetSize;
        var step = 2 * Math.PI / this.numCircles;
        var i = this.numCircles;
        var circleObject;
        var radius = (this.parentSize - offset) * 0.5;

        while (i--) {
          var circle = this$1._createCircle();

          var x = Math.round(this$1.parentSize * 0.5 + radius * Math.cos(angle) - circle.clientWidth * 0.5) - offset * 0.5;
          var y = Math.round(this$1.parentSize * 0.5 + radius * Math.sin(angle) - circle.clientHeight * 0.5) - offset * 0.5;
          this$1.spinner.appendChild(circle);
          circle.style.left = x + "px";
          circle.style.top = y + "px";
          angle += step;
          circleObject = new CircleObject(circle, i);
          this$1.circleObjects.push(circleObject);
        }
      };

      return Spinner;
    }();

    var textField = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"textField",staticClass:"ms-TextField",class:_vm.textFieldClass},[_c('label',{staticClass:"ms-Label"},[_vm._v(_vm._s(_vm.label))]),_vm._v(" "),(_vm.type == 'multiline')?_c('textarea',_vm._b({staticClass:"ms-TextField-field",attrs:{"placeholder":_vm.placeholder,"type":"text","disabled":_vm.disabled},domProps:{"value":_vm.value},on:{"input":_vm.updateValue,"change":_vm.changeEvent,"blur":_vm.blurEvent}},'textarea',_vm.attrs,false)):_c('input',_vm._b({staticClass:"ms-TextField-field",attrs:{"placeholder":_vm.placeholder,"type":_vm.inputType,"disabled":_vm.disabled},domProps:{"value":_vm.value},on:{"input":_vm.updateValue,"change":_vm.changeEvent,"blur":_vm.blurEvent}},'input',_vm.attrs,false))])},staticRenderFns: [],
      name: 'ou-text-field',
      inheritAttrs: false,
      mixins: [type('multiline', 'underlined'), disabled],

      props: {
        value: [String, Number],
        label: String,
        placeholder: String,
        inputType: {
          type: String,
          default: 'text',
          validator: function validator(value) {
            return ['text', 'password', 'file', 'number'].includes(value);
          }
        }
      },

      computed: {
        attrs: function attrs(){return this.$attrs},
        textFieldClass: function textFieldClass() {
          var obj;

          return ( obj = {}, obj[("ms-TextField--" + (this.type))] = !!this.type, obj['is-disabled'] =  this.disabled, obj );
        }
      },

      mounted: function mounted() {
        new this.$fabric.TextField(this.$refs.textField);
      },

      methods: {
        updateValue: function updateValue(event) {
          this.$emit('input', event.target.value);
        },
        blurEvent: function blurEvent(event){
          this.$emit('blur', event.target.value);
        },
        changeEvent: function changeEvent(event) {
          this.$emit('change', event.target.value);
        }
      }
    };

    var TextFieldConsts;

    (function (TextFieldConsts) {
      var Type;

      (function (Type) {
        Type[Type["Placeholder"] = 0] = "Placeholder";
        Type[Type["Underlined"] = 1] = "Underlined";
      })(Type = TextFieldConsts.Type || (TextFieldConsts.Type = {}));
    })(TextFieldConsts || (TextFieldConsts = {}));

    var TextField = function () {
      function TextField(container) {
        this._container = container;
        this._type = [];
        this._textField = this._container.querySelector(".ms-TextField-field");
        this._textFieldLabel = this._container.querySelector(".ms-Label");

        this._setTextFieldType();

        this._addListeners();
      }

      TextField.prototype._setTextFieldType = function () {
        if (this._container.classList.contains("ms-TextField--placeholder")) {
          this._type.push(TextFieldConsts.Type.Placeholder);
        }

        if (this._container.classList.contains("ms-TextField--underlined")) {
          this._type.push(TextFieldConsts.Type.Underlined);
        }
      };

      TextField.prototype._addListeners = function () {
        var _this = this;

        this._textFieldLabel.addEventListener("click", function (event) {
          _this._textField.focus();
        });

        if (this._type.indexOf(TextFieldConsts.Type.Placeholder) >= 0) {
          this._textField.addEventListener("focus", function (event) {
            _this._textFieldLabel.style.display = "none";
          });

          this._textField.addEventListener("blur", function (event) {
            if (_this._textField.value.length === 0) {
              _this._textFieldLabel.style.display = "block";
            }
          });
        }

        if (this._type.indexOf(TextFieldConsts.Type.Underlined) >= 0) {
          this._textField.addEventListener("focus", function (event) {
            _this._container.classList.add("is-active");
          });

          this._textField.addEventListener("blur", function (event) {
            _this._container.classList.remove("is-active");
          });
        }
      };

      return TextField;
    }();

    var toggle = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"toggle",staticClass:"ms-Toggle",class:_vm.toggleClass},[(_vm.description)?_c('span',{staticClass:"ms-Toggle-description"},[_vm._v(" "+_vm._s(_vm.description)+" ")]):_vm._e(),_vm._v(" "),_c('input',{staticClass:"ms-Toggle-input",attrs:{"type":"checkbox"}}),_vm._v(" "),_c('span',{staticClass:"ms-Toggle-trigger",on:{"click":_vm.toggle}},[_c('label',{ref:"toggleLabel",staticClass:"ms-Toggle-field",class:{ 'is-selected': _vm.value },attrs:{"tabindex":"0"}},[_c('span',{staticClass:"ms-Label ms-Label--off"},[_vm._v(_vm._s(_vm.offLabel))]),_vm._v(" "),_c('span',{staticClass:"ms-Label ms-Label--on"},[_vm._v(_vm._s(_vm.onLabel))])])])])},staticRenderFns: [],
      name: 'ou-toggle',

      mixins: [type('textLeft'), disabled],

      props: {
        value: Boolean,
        onLabel: String,
        offLabel: String,
        description: String
      },

      computed: {
        toggleClass: function toggleClass() {
          var obj;

          return ( obj = {}, obj[("ms-Toggle--" + (this.type))] = !!this.type, obj['is-disabled'] =  this.disabled, obj );
        }
      },

      mounted: function mounted() {
        new this.$fabric.Toggle(this.$refs.toggle);
      },

      methods: {
        toggle: function toggle() {
          if (!this.disabled) {
            this.$emit('input', !this.value);
          }
        }
      }
    };

    var Toggle = function () {
      function Toggle(container) {
        this._container = container;
        this._toggleField = this._container.querySelector(".ms-Toggle-field");

        this._addListeners();
      }

      Toggle.prototype.removeListeners = function () {
        this._toggleField.removeEventListener("click", this._toggleHandler.bind(this));
      };

      Toggle.prototype._addListeners = function () {
        var _this = this;

        this._toggleField.addEventListener("click", this._toggleHandler.bind(this), false);

        this._toggleField.addEventListener("keyup", function (e) {
          return e.keyCode === 32 ? _this._toggleHandler() : null;
        }, false);
      };

      Toggle.prototype._toggleHandler = function () {
        this._toggleField.classList.toggle("is-selected");
      };

      return Toggle;
    }();

    //
    var component = {
      components: {
        uiSearchBox: uiSearchbox
      },
      watch: {
        searchQuery(val) {
          this.pagesAfterSearch(this.pagesWhereIAmContactPerson);
        }
      },
      created() {
        this.getContactPersonPages();
      }
    };

    component.originalTemplate = "pagesToRevisionContactPerson";
    component.template = `
<wizdomWebpart data-v-08f483d9 :environmentInfo="environmentInfo" :chromeProperties="webpartProperties.chromeProperties"
  :dynamicData="filteredSearch.length" :title="'Pages to revision - Where i am contactperson' | translate">

  <div data-v-08f483d9 v-if="filteredSearch" class="container">
    
    <div data-v-08f483d9 v-if="webpartProperties.search">
      <div data-v-08f483d9 class="search">
        <uiSearchBox data-v-08f483d9 v-model="searchQuery"></uiSearchBox>
      </div>
    </div>   
    
    <div data-v-08f483d9 class="ms-Grid revert-Padding">
      <div data-v-08f483d9 class="ms-Grid-row header-container">
        <div data-v-08f483d9 class="ms-Grid-col ms-md6 header-table">{{ 'Title' | translate}}</div>
        <div data-v-08f483d9 class="ms-Grid-col ms-md6 header-table">{{ 'Date' | translate}}</div>
      </div>

      <div data-v-08f483d9 class="ms-Grid-row list-container">
        <div data-v-08f483d9  class="ms-Grid-col ms-md12">
          <div data-v-08f483d9 class="ms-Grid-row content-table" v-for="(page) in slicePage(filteredSearch, currentPage, pagesize)" :key="page.id">
            <div data-v-08f483d9 class="ms-Grid-col ms-md6 line-height-modifier word-break">
              <a data-v-08f483d9 v-if="page.title" :href="page.path">{{page.title}}</a>
              <a data-v-08f483d9 v-else :href="page.path">{{"No title" | translate}}</a>
            </div>
            <div data-v-08f483d9 class="ms-Grid-col ms-md6 line-height-modifier"><a data-v-08f483d9 :href="page.path">{{page.date.substring(0,10)}}</a></div>
          </div>
        </div>
        <div data-v-08f483d9 v-if="filteredSearch.length === 0" class="ms-Grid-col ms-md12">
          <div data-v-08f483d9 class="ms-Grid-row content-table">
            <div data-v-08f483d9 class="ms-Grid-col line-height-modifier">
              {{"No pages found" | translate}}
            </div>
          </div>
        </div>
      </div>

    </div>
    <!-- Pagination -->
    <div data-v-08f483d9 class="pagingSpacer"></div>
    <pagination data-v-08f483d9 class="pagination" v-if="filteredSearch && filteredSearch.length > pagesize" :pageSize="pagesize" :length="filteredSearch.length" v-model="currentPage"></pagination>
  </div>

</wizdomWebpart>
`;
    component.styles = `

.container[data-v-08f483d9] .ms-SearchBox {
  height: 30px !important;
}
.container[data-v-08f483d9] .ms-SearchBox .ms-SearchBox-field {
    height: 30px !important;
}
.container[data-v-08f483d9] .ms-SearchBox .ms-SearchBox-label {
    height: 30px !important;
}
.container[data-v-08f483d9] .ms-SearchBox .ms-SearchBox-label .ms-SearchBox-icon {
      color: "[theme:themePrimary, default:#333]";
}
.container[data-v-08f483d9] .ms-SearchBox .ms-Icon--Search {
    content: "" !important;
}
.container[data-v-08f483d9] .ms-SearchBox .ms-CommandButton {
    display: none !important;
}
.search[data-v-08f483d9] {
  padding-top: 20px;
  text-align: right;
  height: 30px;
}
.header-container[data-v-08f483d9] {
  margin-top: 20px;
  padding: 8px 8px;
  color: "[theme:bodyText, default:#333]";
  border-bottom: 1px solid "[theme:neutralLight, default:#eaeaea]";
}
.header-table[data-v-08f483d9] {
  font-weight: 600;
}
.title-padding[data-v-08f483d9] {
  padding-right: 10px;
}
.line-height-modifier[data-v-08f483d9] {
  line-height: 27px;
}
a[data-v-08f483d9] {
  text-decoration: none;
  cursor: pointer;
  line-height: 27px;
  color: "[theme:bodyText, default:#333]";
}
div.content-table[data-v-08f483d9] {
  color: "[theme:bodyText, default:#333]";
  border-bottom: 1px solid "[theme:neutralLight, default:#eaeaea]";
  padding: 8px 8px;
}
div.content-table[data-v-08f483d9]:hover {
    background-color: "[theme:neutralLighterAlt, default:#ffffff]";
}
div.content-table .word-break[data-v-08f483d9] {
    word-break: break-word;
}
.pagingSpacer[data-v-08f483d9] {
  height: 10px;
  padding-top: 15px;
}
.font-size[data-v-08f483d9] {
  font-size: 10px;
}
.pagination[data-v-08f483d9] {
  position: absolute;
  bottom: 5px;
  right: 24px;
  color: "[theme:bodyText, default:#333]";
}
.pagination[data-v-08f483d9] .ms-Icon {
    color: "[theme:themePrimary, default:#333]";
}


`;

    return component;

});
